function [xV, yV] = projectSphere(vertecies, pt)
% function [xV, yV] = projectSphere(vertecies, pt)
% 
% Project a sphere onto a plane directly across from pt and tangent to a
% sphere. 
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
%
% Based on:
%% Triangulate a set of points on the unit sphere using idea of stereographical projection
%% http://mathforum.org/epigone/sci.math.num-analysis/hahswimpcrim/32DD70B8.8DC@research.att.com
%%	Author:  Tianli Yu	https://netfiles.uiuc.edu/tyu/www/tianli/
%%	Date:	Thursday Sep. 30 2004  8:58 pm

%% Step 1: projection

%% build a rotation matrix that rotate the first point to (0, 0, -1)
R3RV = - pt;
if (pt(3) ~= 0)
    R2RV = [0, -R3RV(3), R3RV(2)];
    R2RV = R2RV / norm(R2RV');
else
    R2RV = [-R3RV(2), R3RV(1), 0];
    R2RV = R2RV / norm(R2RV');
end

R1RV = cross(R3RV, R2RV, 2);
RotateM = [R1RV; R2RV; R3RV];

%% the rotated vertex list
RotVM = vertecies * RotateM';

%% here use the projection center of (0, 0, -1), project all points to z = 0
%% solve the simple ray-plane intersection equation
tV = -ones(size(vertecies,1), 1) ./ (RotVM(:, 3) + 1);
xV = RotVM(:, 1) .* tV;
yV = RotVM(:, 2) .* tV;
