function area = sphPolyArea(Pt, Neighbors)
% function area = sphPolyArea(Pt, Neighbors)
%
% Compute the area of a spherical polygon given the polygon (Neighbors) and
% a point within the polygon. Note that the first point need not be
% duplicated. The first point is assumed to connect to the last point. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
if(length(Neighbors)>0)
Neighbors = Neighbors([1:end 1],:);
area = 0;
for j=1:(length(Neighbors)-1)
    area = area+ sphTriArea([Pt(1) Neighbors(j+(0:1),1)'],...
        [Pt(2) Neighbors(j+(0:1),2)'],[Pt(3) Neighbors(j+(0:1),3)']);
end
else
area=0;
end
% 
% figure;
% fillSphTri(10,Neighbors([1:end ],1), Neighbors([1:end ],2), Neighbors([1:end ],3),[1 1 0],'FaceAlpha',.1);
% hold on;
% for j=1:(length(Neighbors)-1)
%     fillSphTri(10,[Pt(1) Neighbors(j+(0:1),1)'],[Pt(2) Neighbors(j+(0:1),2)'],[Pt(3) Neighbors(j+(0:1),3)'],[1 0 1],'FaceAlpha',.2)
%     
%     hold on;
%     pause
%     
% end