function area = sphTriArea(x,y,z)
% function area = sphTriArea(x,y,z)
% 
% Compute the area of a spherical triangle defined
% by the points x(1:3), y(1:3), z(1:3) by calculating 
% the spherical excess. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

r = (x.^2+y.^2+z.^2);
if(~((abs(r(:,1)-r(:,2))<10*eps).*(abs(r(:,1)-r(:,3))<10*eps)))
    error('Points do not on a sphere to within working precision.');
end
r = r(:,1);
% A  B = |A| * |B| * Cos(theta)
arclenAtoB =  r.*acos((x(:,1).*x(:,2)+y(:,1).*y(:,2)+z(:,1).*z(:,2))./...
    (x(:,1).*x(:,1)+y(:,1).*y(:,1)+z(:,1).*z(:,1))./ ...
    (x(:,2).*x(:,2)+y(:,2).*y(:,2)+z(:,2).*z(:,2)));
arclenAtoC =  r.*acos((x(:,1).*x(:,3)+y(:,1).*y(:,3)+z(:,1).*z(:,3))./...
    (x(:,1).*x(:,1)+y(:,1).*y(:,1)+z(:,1).*z(:,1))./ ...
    (x(:,3).*x(:,3)+y(:,3).*y(:,3)+z(:,3).*z(:,3)));
arclenBtoC =  r.*acos((x(:,2).*x(:,3)+y(:,2).*y(:,3)+z(:,2).*z(:,3))./...
    (x(:,2).*x(:,2)+y(:,2).*y(:,2)+z(:,2).*z(:,2))./ ...
    (x(:,3).*x(:,3)+y(:,3).*y(:,3)+z(:,3).*z(:,3)));
s = (arclenAtoB+arclenBtoC+arclenAtoC)/2;

E = 4*atan(sqrt(tan(s/2).*tan((s-arclenAtoB)/2).*tan((s-arclenAtoC)/2).*tan((s-arclenBtoC)/2)));

area = E.*r.^2;
