/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;

public class OrdinalClassClassifier
extends Classifier
implements OptionHandler {
    private Classifier[] m_Classifiers;
    private MakeIndicator[] m_ClassFilters;
    private Classifier m_Classifier = new ZeroR();
    private Attribute m_ClassAttribute;
    private ZeroR m_ZeroR;

    public String globalInfo() {
        return " Meta classifier that allows standard classification algorithms to be applied to ordinal class problems.  For more information see: Frank, E. and Hall, M. (in press). A simple approach to ordinal prediction. 12th European Conference on Machine Learning. Freiburg, Germany.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("OrdinalClassClassifier: class should be declared nominal!");
        }
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        this.m_ZeroR = new ZeroR();
        this.m_ZeroR.buildClassifier(instances);
        int n = instances.numClasses() - 1;
        int n2 = n = n == 0 ? 1 : n;
        if (n == 1) {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, 1);
            this.m_Classifiers[0].buildClassifier(instances);
        } else {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, n);
            this.m_ClassFilters = new MakeIndicator[n];
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.m_ClassFilters[i] = new MakeIndicator();
                this.m_ClassFilters[i].setAttributeIndex("" + (instances.classIndex() + 1));
                this.m_ClassFilters[i].setValueIndices("" + (i + 2) + "-last");
                this.m_ClassFilters[i].setNumeric(false);
                this.m_ClassFilters[i].setInputFormat(instances);
                Instances instances2 = Filter.useFilter(instances, this.m_ClassFilters[i]);
                this.m_Classifiers[i].buildClassifier(instances2);
            }
        }
        this.m_ClassAttribute = instances.classAttribute();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (this.m_Classifiers.length == 1) {
            return this.m_Classifiers[0].distributionForInstance(instance);
        }
        double[] dArray = new double[instance.numClasses()];
        double[][] dArray2 = new double[this.m_ClassFilters.length][0];
        for (n = 0; n < this.m_ClassFilters.length; ++n) {
            this.m_ClassFilters[n].input(instance);
            this.m_ClassFilters[n].batchFinished();
            dArray2[n] = this.m_Classifiers[n].distributionForInstance(this.m_ClassFilters[n].output());
        }
        for (n = 0; n < instance.numClasses(); ++n) {
            if (n == 0) {
                dArray[n] = dArray2[0][0];
                continue;
            }
            if (n == instance.numClasses() - 1) {
                dArray[n] = dArray2[n - 1][1];
                continue;
            }
            dArray[n] = dArray2[n - 1][1] - dArray2[n][1];
            if (dArray[n] > 0.0) continue;
            System.err.println("Warning: estimated probability " + dArray[n] + ". Rounding to 0.");
            dArray[n] = 0.0;
        }
        if (Utils.gr(Utils.sum(dArray), 0.0)) {
            Utils.normalize(dArray);
            return dArray;
        }
        return this.m_ZeroR.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSets the base classifier.", "W", 1, "-W <base classifier>"));
        if (this.m_Classifier != null) {
            try {
                vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
                Enumeration enumeration = this.m_Classifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((Option)enumeration.nextElement());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 3];
        int n = 0;
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String classifierTipText() {
        return "Sets the Classifier used as the basis for the multi-class classifier.";
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "OrdinalClassClassifier: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OrdinalClassClassifier\n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append("Classifier ").append(i + 1);
            if (this.m_Classifiers[i] != null) {
                if (this.m_ClassFilters != null && this.m_ClassFilters[i] != null) {
                    stringBuffer.append(", using indicator values: ");
                    stringBuffer.append(this.m_ClassFilters[i].getValueRange());
                }
                stringBuffer.append('\n');
                stringBuffer.append(this.m_Classifiers[i].toString() + "\n");
                continue;
            }
            stringBuffer.append(" Skipped (no training examples)\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            OrdinalClassClassifier ordinalClassClassifier = new OrdinalClassClassifier();
            System.out.println(Evaluation.evaluateModel(ordinalClassClassifier, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

