/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.EM;
import weka.core.Attribute;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class ClusterMembership
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected DensityBasedClusterer m_clusterer = new EM();
    protected Range m_ignoreAttributesRange = null;
    protected Filter m_removeAttributes = new Remove();
    static /* synthetic */ Class class$weka$clusterers$DensityBasedClusterer;

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_removeAttributes = null;
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.outputFormatPeek() == null) {
            Copyable copyable;
            Instances instances;
            Instances instances2 = instances = this.getInputFormat();
            if (this.m_ignoreAttributesRange != null || instances.classIndex() >= 0) {
                instances2 = new Instances(instances);
                this.m_removeAttributes = new Remove();
                String string = "";
                if (this.m_ignoreAttributesRange != null) {
                    string = string + this.m_ignoreAttributesRange.getRanges();
                }
                if (instances.classIndex() >= 0) {
                    string = string.length() > 0 ? string + "," + (instances.classIndex() + 1) : "" + (instances.classIndex() + 1);
                }
                ((Remove)this.m_removeAttributes).setAttributeIndices(string);
                ((Remove)this.m_removeAttributes).setInvertSelection(false);
                this.m_removeAttributes.setInputFormat(instances);
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.m_removeAttributes.input(instances.instance(i));
                }
                this.m_removeAttributes.batchFinished();
                instances2 = this.m_removeAttributes.getOutputFormat();
                while ((copyable = this.m_removeAttributes.output()) != null) {
                    instances2.add((Instance)copyable);
                }
            }
            this.m_clusterer.buildClusterer(instances2);
            int n = instances.classIndex() >= 0 ? this.m_clusterer.numberOfClusters() + 1 : this.m_clusterer.numberOfClusters();
            copyable = new FastVector(n);
            for (int i = 0; i < this.m_clusterer.numberOfClusters(); ++i) {
                copyable.addElement(new Attribute("pCluster" + i));
            }
            if (instances.classIndex() >= 0) {
                copyable.addElement(instances.classAttribute().copy());
            }
            Instances instances3 = new Instances(instances.relationName() + "_clusterMembership", (FastVector)copyable, 0);
            if (instances.classIndex() >= 0) {
                instances3.setClassIndex(instances3.numAttributes() - 1);
            }
            this.setOutputFormat(instances3);
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.convertInstance(instances.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    protected double[] logs2densities(Instance instance) throws Exception {
        double[] dArray = this.m_clusterer.logDensityPerClusterForInstance(instance);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(dArray[i]);
        }
        return dArray;
    }

    protected void convertInstance(Instance instance) throws Exception {
        double[] dArray;
        if (this.m_removeAttributes != null) {
            this.m_removeAttributes.input(instance);
            dArray = this.logs2densities(this.m_removeAttributes.output());
        } else {
            dArray = this.logs2densities(instance);
        }
        double[] dArray2 = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        if (instance.classIndex() >= 0) {
            dArray2[dArray2.length - 1] = instance.classValue();
        }
        this.push(new Instance(instance.weight(), dArray2));
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull name of clusterer to use (required).\n\teg: weka.clusterers.EM", "W", 1, "-W <clusterer name>"));
        vector.addElement(new Option("\tThe range of attributes the clusterer should ignore.\n\t(the class attribute is automatically ignored)", "I", 1, "-I <att1,att2-att4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A clusterer must be specified with the -W option.");
        }
        this.setDensityBasedClusterer((DensityBasedClusterer)Utils.forName(class$weka$clusterers$DensityBasedClusterer == null ? (class$weka$clusterers$DensityBasedClusterer = ClusterMembership.class$("weka.clusterers.DensityBasedClusterer")) : class$weka$clusterers$DensityBasedClusterer, string, Utils.partitionOptions(stringArray)));
        this.setIgnoredAttributeIndices(Utils.getOption('I', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_clusterer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 5];
        int n = 0;
        if (!this.getIgnoredAttributeIndices().equals("")) {
            stringArray2[n++] = "-I";
            stringArray2[n++] = this.getIgnoredAttributeIndices();
        }
        if (this.m_clusterer != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getDensityBasedClusterer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "A filter that uses a clusterer to generate cluster membership probabilities; filtered instances are composed of these probabilities plus the class attribute (if set in the input data). The class attribute (if set) and any user specified attributes are ignored during the clustering operation";
    }

    public String clustererTipText() {
        return "The clusterer that will generate membership probabilities for instances.";
    }

    public void setDensityBasedClusterer(DensityBasedClusterer densityBasedClusterer) {
        this.m_clusterer = densityBasedClusterer;
    }

    public DensityBasedClusterer getDensityBasedClusterer() {
        return this.m_clusterer;
    }

    public String ignoredAttributeIndicesTipText() {
        return "The range of attributes to be ignored by the clusterer. eg: first-3,5,9-last";
    }

    public String getIgnoredAttributeIndices() {
        if (this.m_ignoreAttributesRange == null) {
            return "";
        }
        return this.m_ignoreAttributesRange.getRanges();
    }

    public void setIgnoredAttributeIndices(String string) {
        if (string == null || string.length() == 0) {
            this.m_ignoreAttributesRange = null;
        } else {
            this.m_ignoreAttributesRange = new Range();
            this.m_ignoreAttributesRange.setRanges(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new ClusterMembership(), stringArray);
            } else {
                Filter.filterFile(new ClusterMembership(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

