/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NumericTransform
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private Range m_Cols = new Range();
    private Class m_Class;
    private Method m_Method;
    private static Class[] PARAM = new Class[]{Double.TYPE};
    static /* synthetic */ Class class$java$lang$Math;

    public String globalInfo() {
        return "Transforms numeric attributes using a given transformation method.";
    }

    public NumericTransform() {
        try {
            this.m_Class = class$java$lang$Math == null ? (class$java$lang$Math = NumericTransform.class$("java.lang.Math")) : class$java$lang$Math;
            this.m_Method = (class$java$lang$Math == null ? (class$java$lang$Math = NumericTransform.class$("java.lang.Math")) : class$java$lang$Math).getMethod("abs", PARAM);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("One of those errors that you should never see");
            noSuchMethodException.printStackTrace();
        }
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (this.m_Class == null) {
            throw new IllegalStateException("No class has been set.");
        }
        if (this.m_Method == null) {
            throw new IllegalStateException("No method has been set.");
        }
        super.setInputFormat(instances);
        this.m_Cols.setUpper(instances.numAttributes() - 1);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[instance.numAttributes()];
        Object[] objectArray = new Double[1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (instance.isMissing(i)) {
                dArray[i] = Instance.missingValue();
                continue;
            }
            if (this.m_Cols.isInRange(i) && instance.attribute(i).isNumeric()) {
                objectArray[0] = new Double(instance.value(i));
                Double d = (Double)this.m_Method.invoke(null, objectArray);
                if (d.isNaN() || d.isInfinite()) {
                    dArray[i] = Instance.missingValue();
                    continue;
                }
                dArray[i] = d;
                continue;
            }
            dArray[i] = instance.value(i);
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        instance2.setDataset(instance.dataset());
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSpecify list of columns to transform. First and last are\n\tvalid indexes (default none). Non-numeric columns are \n\tskipped.", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        vector.addElement(new Option("\tSets the class containing transformation method.\n\t(default java.lang.Math)", "C", 1, "-C <string>"));
        vector.addElement(new Option("\tSets the method. (default abs)", "M", 1, "-M <string>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setAttributeIndices(Utils.getOption('R', stringArray));
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        this.setClassName(Utils.getOption('C', stringArray));
        this.setMethodName(Utils.getOption('M', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        if (this.m_Class != null) {
            stringArray[n++] = "-C";
            stringArray[n++] = this.getClassName();
        }
        if (this.m_Method != null) {
            stringArray[n++] = "-M";
            stringArray[n++] = this.getMethodName();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String classNameTipText() {
        return "Name of the class containing the method used for the transformation.";
    }

    public String getClassName() {
        return this.m_Class.getName();
    }

    public void setClassName(String string) throws ClassNotFoundException {
        this.m_Class = Class.forName(string);
    }

    public String methodNameTipText() {
        return "Name of the method used for the transformation.";
    }

    public String getMethodName() {
        return this.m_Method.getName();
    }

    public void setMethodName(String string) throws NoSuchMethodException {
        this.m_Method = this.m_Class.getMethod(string, PARAM);
    }

    public String invertSelectionTipText() {
        return "Whether to process the inverse of the given attribute ranges.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Cols.setInvert(bl);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_Cols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new NumericTransform(), stringArray);
            } else {
                Filter.filterFile(new NumericTransform(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

