/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BeanVisual
extends JPanel
implements Serializable {
    public static final String ICON_PATH = "weka/gui/beans/icons/";
    public static final int NORTH_CONNECTOR = 0;
    public static final int SOUTH_CONNECTOR = 1;
    public static final int EAST_CONNECTOR = 2;
    public static final int WEST_CONNECTOR = 3;
    protected String m_iconPath;
    protected String m_animatedIconPath;
    protected transient ImageIcon m_icon;
    protected transient ImageIcon m_animatedIcon;
    protected String m_visualName;
    protected JLabel m_visualLabel;
    private boolean m_stationary = true;
    private PropertyChangeSupport m_pcs = new PropertyChangeSupport(this);
    private boolean m_displayConnectors = false;

    public BeanVisual(String string, String string2, String string3) {
        this.loadIcons(string2, string3);
        this.m_visualName = string;
        this.m_visualLabel = new JLabel(this.m_icon);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visualLabel, "Center");
        Dimension dimension = this.m_visualLabel.getPreferredSize();
        Dimension dimension2 = new Dimension((int)dimension.getWidth() + 10, (int)dimension.getHeight() + 10);
        this.setMinimumSize(dimension2);
        this.setPreferredSize(dimension2);
        this.setMaximumSize(dimension2);
    }

    public void scale(int n) {
        if (this.m_icon != null) {
            this.removeAll();
            Image image = this.m_icon.getImage();
            int n2 = this.m_icon.getIconWidth();
            int n3 = this.m_icon.getIconHeight();
            int n4 = n2 / n;
            image = image.getScaledInstance(n2 -= n4, n3 -= n4, 4);
            this.m_icon = new ImageIcon(image);
            this.m_visualLabel = new JLabel(this.m_icon);
            this.add((Component)this.m_visualLabel, "Center");
            Dimension dimension = this.m_visualLabel.getPreferredSize();
            Dimension dimension2 = new Dimension((int)dimension.getWidth() + 10, (int)dimension.getHeight() + 10);
            this.setMinimumSize(dimension2);
            this.setPreferredSize(dimension2);
            this.setMaximumSize(dimension2);
        }
    }

    public boolean loadIcons(String string, String string2) {
        Image image;
        boolean bl = true;
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.m_icon = new ImageIcon(image);
            if (this.m_visualLabel != null) {
                this.m_visualLabel.setIcon(this.m_icon);
            }
        }
        uRL = ClassLoader.getSystemResource(string2);
        if (uRL == null) {
            bl = false;
        } else {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.m_animatedIcon = new ImageIcon(image);
        }
        this.m_iconPath = string;
        this.m_animatedIconPath = string2;
        return bl;
    }

    public void setText(String string) {
        this.m_visualName = string;
        this.m_pcs.firePropertyChange("label", null, null);
    }

    public String getText() {
        return this.m_visualName;
    }

    public void setStatic() {
        this.m_visualLabel.setIcon(this.m_icon);
    }

    public void setAnimated() {
        this.m_visualLabel.setIcon(this.m_animatedIcon);
    }

    public Point getClosestConnectorPoint(Point point) {
        int n;
        int n2 = this.getParent().getX();
        int n3 = this.getParent().getY();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = n2 + n4 / 2;
        int n7 = n3 + n5 / 2;
        int n8 = (int)point.getX();
        int n9 = (int)point.getY();
        Point point2 = new Point();
        int n10 = Math.abs(n8 - n6) < Math.abs(n9 - n7) ? n6 : (n = n8 < n6 ? n2 : n2 + n4);
        int n11 = Math.abs(n9 - n7) < Math.abs(n8 - n6) ? n7 : (n9 < n7 ? n3 : n3 + n5);
        point2.setLocation(n, n11);
        return point2;
    }

    public Point getConnectorPoint(int n) {
        int n2 = this.getParent().getX();
        int n3 = this.getParent().getY();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = n2 + n4 / 2;
        int n7 = n3 + n5 / 2;
        switch (n) {
            case 0: {
                return new Point(n6, n3);
            }
            case 1: {
                return new Point(n6, n3 + n5);
            }
            case 3: {
                return new Point(n2, n7);
            }
            case 2: {
                return new Point(n2 + n4, n7);
            }
        }
        System.err.println("Unrecognised connectorPoint (BeanVisual)");
        return new Point(n2, n3);
    }

    public ImageIcon getStaticIcon() {
        return this.m_icon;
    }

    public ImageIcon getAnimatedIcon() {
        return this.m_animatedIcon;
    }

    public void setDisplayConnectors(boolean bl) {
        this.m_displayConnectors = bl;
        this.repaint();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.m_displayConnectors) {
            graphics.setColor(Color.blue);
            int n = (int)((double)this.getWidth() / 2.0);
            int n2 = (int)((double)this.getHeight() / 2.0);
            graphics.fillOval(n - 2, 0, 5, 5);
            graphics.fillOval(n - 2, this.getHeight() - 5, 5, 5);
            graphics.fillOval(0, n2 - 2, 5, 5);
            graphics.fillOval(this.getWidth() - 5, n2 - 2, 5, 5);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            this.loadIcons(this.m_iconPath, this.m_animatedIconPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

