/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SwapValues;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Visible;

public class ClassValuePicker
extends JPanel
implements Visible,
DataSourceListener,
BeanCommon,
EventConstraints,
Serializable {
    private int m_classValueIndex = 0;
    private Instances m_connectedFormat;
    private Object m_dataProvider;
    private Vector m_dataListeners = new Vector();
    private Vector m_dataFormatListeners = new Vector();
    protected transient Logger m_logger = null;
    protected BeanVisual m_visual = new BeanVisual("ClassValuePicker", "weka/gui/beans/icons/ClassValuePicker.gif", "weka/gui/beans/icons/ClassValuePicker_animated.gif");

    public String globalInfo() {
        return "Designate which class value is to be considered the \"positive\" class value (useful for ROC style curves).";
    }

    public ClassValuePicker() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public Instances getConnectedFormat() {
        if (this.m_connectedFormat == null) {
            System.err.println("Is null!!!!!!");
        }
        return this.m_connectedFormat;
    }

    public void setClassValueIndex(int n) {
        this.m_classValueIndex = n;
        if (this.m_connectedFormat != null) {
            this.notifyDataFormatListeners();
        }
    }

    public int getClassValueIndex() {
        return this.m_classValueIndex;
    }

    public void acceptDataSet(DataSetEvent dataSetEvent) {
        if (dataSetEvent.isStructureOnly() && (this.m_connectedFormat == null || !this.m_connectedFormat.equalHeaders(dataSetEvent.getDataSet()))) {
            this.m_connectedFormat = new Instances(dataSetEvent.getDataSet(), 0);
            this.notifyDataFormatListeners();
        }
        Instances instances = dataSetEvent.getDataSet();
        Instances instances2 = this.assignClassValue(instances);
        dataSetEvent = new DataSetEvent(this, instances2);
        this.notifyDataListeners(dataSetEvent);
    }

    private Instances assignClassValue(Instances instances) {
        block7: {
            if (instances.classIndex() < 0) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("No class attribute defined in data set (ClassValuePicker)");
                }
                return instances;
            }
            if (instances.classAttribute().isNumeric()) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("Class attribute must be nominal (ClassValuePicker)");
                }
                return instances;
            }
            if (this.m_classValueIndex != 0) {
                try {
                    SwapValues swapValues = new SwapValues();
                    swapValues.setAttributeIndex("" + (instances.classIndex() + 1));
                    swapValues.setFirstValueIndex("first");
                    swapValues.setSecondValueIndex("" + (this.m_classValueIndex + 1));
                    swapValues.setInputFormat(instances);
                    Instances instances2 = Filter.useFilter(instances, swapValues);
                    instances2.setRelationName(instances.relationName());
                    return instances2;
                }
                catch (Exception exception) {
                    if (this.m_logger == null) break block7;
                    this.m_logger.logMessage("Unable to swap class attibute values (ClassValuePicker)");
                }
            }
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent dataSetEvent) {
        Vector vector;
        ClassValuePicker classValuePicker = this;
        synchronized (classValuePicker) {
            vector = (Vector)this.m_dataListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                System.err.println("Notifying data listeners (ClassValuePicker)");
                ((DataSourceListener)vector.elementAt(i)).acceptDataSet(dataSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataFormatListeners() {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.m_dataFormatListeners.clone();
        }
        if (vector.size() > 0) {
            serializable = new DataSetEvent(this, this.m_connectedFormat);
            for (int i = 0; i < vector.size(); ++i) {
                ((DataFormatListener)vector.elementAt(i)).newDataFormat((DataSetEvent)serializable);
            }
        }
    }

    public synchronized void addDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.addElement(dataSourceListener);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.removeElement(dataSourceListener);
    }

    public synchronized void addDataFormatListener(DataFormatListener dataFormatListener) {
        this.m_dataFormatListeners.addElement(dataFormatListener);
    }

    public synchronized void removeDataFormatListener(DataFormatListener dataFormatListener) {
        this.m_dataFormatListeners.removeElement(dataFormatListener);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassValuePicker.gif", "weka/gui/beans/icons/ClassValuePicker_animated.gif");
    }

    public boolean connectionAllowed(String string) {
        return string.compareTo("dataSet") != 0 || this.m_dataProvider == null;
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string) && string.compareTo("dataSet") == 0) {
            this.m_dataProvider = object;
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        if (string.compareTo("dataSet") == 0 && this.m_dataProvider == object) {
            this.m_dataProvider = null;
        }
    }

    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    public void stop() {
    }

    public boolean eventGeneratable(String string) {
        if (string.compareTo("dataSet") != 0) {
            return false;
        }
        if (string.compareTo("dataSet") == 0) {
            if (this.m_dataProvider == null) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
            if (this.m_dataProvider instanceof EventConstraints && !((EventConstraints)this.m_dataProvider).eventGeneratable("dataSet")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        return true;
    }
}

