/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Resample;
import weka.gui.ExtensionFileFilter;
import weka.gui.visualize.ClassPanel;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class MatrixPanel
extends JPanel {
    private final Plot m_plotsPanel;
    protected final ClassPanel m_cp = new ClassPanel();
    protected JPanel optionsPanel;
    protected JSplitPane jp;
    protected JButton m_updateBt = new JButton("Update");
    protected JButton m_selAttrib = new JButton("Select Attributes");
    protected Instances m_data = null;
    protected JList m_attribList = new JList();
    protected final JScrollPane m_js = new JScrollPane();
    protected JComboBox m_classAttrib = new JComboBox();
    protected JSlider m_plotSize = new JSlider(50, 500, 100);
    protected JSlider m_pointSize = new JSlider(1, 10, 1);
    protected JSlider m_jitter = new JSlider(0, 20, 0);
    private Random rnd = new Random();
    private int[][] jitterVals;
    private int datapointSize = 1;
    protected JTextField m_resamplePercent = new JTextField(5);
    protected JButton m_resampleBt = new JButton("SubSample % :");
    protected JTextField m_rseed = new JTextField(5);
    protected JRadioButton origDist = new JRadioButton("Class distribution as in input data");
    protected JRadioButton unifDist = new JRadioButton("Uniform class distribution");
    private ButtonGroup distGroup = new ButtonGroup();
    private final JLabel m_plotSizeLb = new JLabel("PlotSize: [100]");
    private final JLabel m_pointSizeLb = new JLabel("PointSize: [10]");
    private int[] m_selectedAttribs;
    private int m_classIndex;
    private int[][] m_points;
    private int[] m_pointColors;
    private boolean[][] m_missing;
    private int[] m_type;
    private Dimension m_plotLBSizeD;
    private Dimension m_pointLBSizeD;
    private FastVector m_colorList = new FastVector();
    private static final Color[] m_defaultColors = new Color[]{Color.blue, Color.red, Color.cyan, new Color(75, 123, 130), Color.pink, Color.green, Color.orange, new Color(255, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0), Color.black};
    private final Color fontColor = new Color(98, 101, 156);
    private final Font f = new Font("Dialog", 1, 11);

    public MatrixPanel() {
        this.m_rseed.setText("1");
        this.origDist.setSelected(true);
        this.distGroup.add(this.origDist);
        this.distGroup.add(this.unifDist);
        this.m_selAttrib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = new JDialog((JFrame)MatrixPanel.this.getTopLevelAncestor(), "Attribute Selection Panel", true);
                JPanel jPanel = new JPanel();
                JScrollPane jScrollPane = new JScrollPane(MatrixPanel.this.m_attribList);
                JButton jButton = new JButton("OK");
                JButton jButton2 = new JButton("Cancel");
                int[] nArray = MatrixPanel.this.m_attribList.getSelectedIndices();
                jButton.addActionListener(new ActionListener(this, jDialog){
                    private final /* synthetic */ JDialog val$jd;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$jd = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$jd.dispose();
                    }
                });
                jButton2.addActionListener(new ActionListener(this, nArray, jDialog){
                    private final /* synthetic */ int[] val$savedSelection;
                    private final /* synthetic */ JDialog val$jd;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$savedSelection = nArray;
                        this.val$jd = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        1.access$000(this.this$1).m_attribList.setSelectedIndices(this.val$savedSelection);
                        this.val$jd.dispose();
                    }
                });
                jDialog.addWindowListener(new WindowAdapter(this, nArray, jDialog){
                    private final /* synthetic */ int[] val$savedSelection;
                    private final /* synthetic */ JDialog val$jd;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$savedSelection = nArray;
                        this.val$jd = jDialog;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        1.access$000(this.this$1).m_attribList.setSelectedIndices(this.val$savedSelection);
                        this.val$jd.dispose();
                    }
                });
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jDialog.getContentPane().add((Component)jScrollPane, "Center");
                jDialog.getContentPane().add((Component)jPanel, "South");
                if (jScrollPane.getPreferredSize().width < 200) {
                    jDialog.setSize(250, 250);
                } else {
                    jDialog.setSize(jScrollPane.getPreferredSize().width + 10, 250);
                }
                jDialog.setLocation(MatrixPanel.this.m_selAttrib.getLocationOnScreen().x, MatrixPanel.this.m_selAttrib.getLocationOnScreen().y - jDialog.getHeight());
                jDialog.setVisible(true);
            }

            static /* synthetic */ MatrixPanel access$000(1 var0) {
                return var0.MatrixPanel.this;
            }
        });
        this.m_updateBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixPanel.this.initInternalFields();
                Plot plot = MatrixPanel.this.m_plotsPanel;
                plot.setCellSize(MatrixPanel.this.m_plotSize.getValue());
                Dimension dimension = new Dimension(MatrixPanel.this.m_selectedAttribs.length * (plot.cellSize + plot.extpad) + 2, MatrixPanel.this.m_selectedAttribs.length * (plot.cellSize + plot.extpad) + 2);
                plot.setPreferredSize(dimension);
                plot.setSize(plot.getPreferredSize());
                plot.setJitter(MatrixPanel.this.m_jitter.getValue());
                MatrixPanel.this.m_js.revalidate();
                MatrixPanel.this.m_cp.setColours(MatrixPanel.this.m_colorList);
                MatrixPanel.this.m_cp.setCindex(MatrixPanel.this.m_classIndex);
                MatrixPanel.this.repaint();
            }
        });
        this.m_updateBt.setPreferredSize(this.m_selAttrib.getPreferredSize());
        this.m_plotSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MatrixPanel.this.m_plotSizeLb.setText("PlotSize: [" + MatrixPanel.this.m_plotSize.getValue() + "]");
                MatrixPanel.this.m_plotSizeLb.setPreferredSize(MatrixPanel.this.m_plotLBSizeD);
                MatrixPanel.this.m_jitter.setMaximum(MatrixPanel.this.m_plotSize.getValue() / 5);
            }
        });
        this.m_pointSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MatrixPanel.this.m_pointSizeLb.setText("PointSize: [" + MatrixPanel.this.m_pointSize.getValue() + "]");
                MatrixPanel.this.m_pointSizeLb.setPreferredSize(MatrixPanel.this.m_pointLBSizeD);
                MatrixPanel.this.datapointSize = MatrixPanel.this.m_pointSize.getValue();
            }
        });
        this.m_resampleBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanel jPanel;
                JLabel jLabel = new JLabel("Random Seed: ");
                JTextField jTextField = MatrixPanel.this.m_rseed;
                JLabel jLabel2 = new JLabel("Subsample as");
                JLabel jLabel3 = new JLabel("% of input: ");
                JTextField jTextField2 = new JTextField(5);
                jTextField2.setText(MatrixPanel.this.m_resamplePercent.getText());
                JButton jButton = new JButton("Done");
                JDialog jDialog = new JDialog(this, (JFrame)MatrixPanel.this.getTopLevelAncestor(), "Attribute Selection Panel", true, jTextField2){
                    private final /* synthetic */ JTextField val$percentTxt;
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$percentTxt = jTextField;
                    }

                    public void dispose() {
                        8.access$1000(this.this$1).m_resamplePercent.setText(this.val$percentTxt.getText());
                        super.dispose();
                    }
                };
                jDialog.setDefaultCloseOperation(2);
                jButton.addActionListener(new ActionListener(this, jDialog){
                    private final /* synthetic */ JDialog val$jd;
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$jd = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$jd.dispose();
                    }
                });
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                JPanel jPanel2 = new JPanel(gridBagLayout);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 2, 2, 2);
                gridBagConstraints.gridwidth = -1;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                jPanel2.add((Component)jTextField, gridBagConstraints);
                gridBagConstraints.insets = new Insets(8, 2, 0, 2);
                gridBagConstraints.weightx = 0.0;
                jPanel2.add((Component)jLabel2, gridBagConstraints);
                gridBagConstraints.insets = new Insets(0, 2, 2, 2);
                gridBagConstraints.gridwidth = -1;
                jPanel2.add((Component)jLabel3, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                jPanel2.add((Component)jTextField2, gridBagConstraints);
                gridBagConstraints.insets = new Insets(8, 2, 2, 2);
                if (MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_classAttrib.getSelectedIndex()).isNominal()) {
                    jPanel = new JPanel(gridBagLayout);
                    jPanel.add((Component)MatrixPanel.this.origDist, gridBagConstraints);
                    jPanel.add((Component)MatrixPanel.this.unifDist, gridBagConstraints);
                    jPanel.setBorder(BorderFactory.createTitledBorder("Class Distribution"));
                    jPanel2.add((Component)jPanel, gridBagConstraints);
                }
                jPanel = new JPanel(gridBagLayout);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                jPanel.add((Component)jPanel2, gridBagConstraints);
                gridBagConstraints.insets = new Insets(8, 4, 8, 4);
                jPanel.add((Component)jButton, gridBagConstraints);
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jPanel, "North");
                jDialog.pack();
                jDialog.setLocation(MatrixPanel.this.m_resampleBt.getLocationOnScreen().x, MatrixPanel.this.m_resampleBt.getLocationOnScreen().y - jDialog.getHeight());
                jDialog.setVisible(true);
            }

            static /* synthetic */ MatrixPanel access$1000(8 var0) {
                return var0.MatrixPanel.this;
            }
        });
        this.optionsPanel = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_plotLBSizeD = this.m_plotSizeLb.getPreferredSize();
        this.m_pointLBSizeD = this.m_pointSizeLb.getPreferredSize();
        this.m_pointSizeLb.setText("PointSize: [1]");
        this.m_pointSizeLb.setPreferredSize(this.m_pointLBSizeD);
        this.m_resampleBt.setPreferredSize(this.m_selAttrib.getPreferredSize());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.m_plotSizeLb, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.m_plotSize, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)this.m_pointSizeLb, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.m_pointSize, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)new JLabel("Jitter: "), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.m_jitter, gridBagConstraints);
        jPanel3.add((Component)this.m_classAttrib, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.m_updateBt, gridBagConstraints);
        jPanel2.add((Component)this.m_selAttrib, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.m_resampleBt, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.m_resamplePercent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Class Colour"));
        jPanel.add((Component)this.m_cp, "South");
        gridBagConstraints.insets = new Insets(8, 5, 2, 5);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        this.optionsPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.optionsPanel.add((Component)jPanel2, gridBagConstraints);
        this.optionsPanel.add((Component)jPanel, gridBagConstraints);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MatrixPanel.this.m_js.setMinimumSize(new Dimension(MatrixPanel.this.getWidth(), MatrixPanel.this.getHeight() - MatrixPanel.this.optionsPanel.getPreferredSize().height - 10));
                MatrixPanel.this.jp.setDividerLocation(MatrixPanel.this.getHeight() - MatrixPanel.this.optionsPanel.getPreferredSize().height - 10);
            }
        });
        this.optionsPanel.setMinimumSize(new Dimension(0, 0));
        this.jp = new JSplitPane(0, this.m_js, this.optionsPanel);
        this.jp.setOneTouchExpandable(true);
        this.jp.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jp, "Center");
        for (int i = 0; i < m_defaultColors.length - 1; ++i) {
            this.m_colorList.addElement(m_defaultColors[i]);
        }
        this.m_selectedAttribs = this.m_attribList.getSelectedIndices();
        this.m_plotsPanel = new Plot();
        this.m_plotsPanel.setLayout(null);
        this.m_js.getHorizontalScrollBar().setUnitIncrement(10);
        this.m_js.getVerticalScrollBar().setUnitIncrement(10);
        this.m_js.setViewportView(this.m_plotsPanel);
        this.m_js.setColumnHeaderView(this.m_plotsPanel.getColHeader());
        this.m_js.setRowHeaderView(this.m_plotsPanel.getRowHeader());
        JLabel jLabel = new JLabel(" Plot Matrix");
        jLabel.setFont(this.f);
        jLabel.setForeground(this.fontColor);
        jLabel.setHorizontalTextPosition(0);
        this.m_js.setCorner("UPPER_LEFT_CORNER", jLabel);
        this.m_cp.setInstances(this.m_data);
        this.m_cp.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.m_cp.addRepaintNotify(this.m_plotsPanel);
    }

    public void initInternalFields() {
        int n;
        int n2;
        int n3;
        Instances instances = this.m_data;
        this.m_classIndex = this.m_classAttrib.getSelectedIndex();
        this.m_selectedAttribs = this.m_attribList.getSelectedIndices();
        double d = 0.0;
        double d2 = 0.0;
        if (Double.parseDouble(this.m_resamplePercent.getText()) < 100.0) {
            try {
                Filter filter;
                if (this.m_data.attribute(this.m_classIndex).isNominal()) {
                    instances = new Instances(this.m_data);
                    instances.setClassIndex(this.m_classIndex);
                    filter = new weka.filters.supervised.instance.Resample();
                    ((weka.filters.supervised.instance.Resample)filter).setRandomSeed(Integer.parseInt(this.m_rseed.getText()));
                    ((weka.filters.supervised.instance.Resample)filter).setSampleSizePercent(Double.parseDouble(this.m_resamplePercent.getText()));
                    if (this.origDist.isSelected()) {
                        ((weka.filters.supervised.instance.Resample)filter).setBiasToUniformClass(0.0);
                    } else {
                        ((weka.filters.supervised.instance.Resample)filter).setBiasToUniformClass(1.0);
                    }
                    ((weka.filters.supervised.instance.Resample)filter).setInputFormat(instances);
                    instances = Filter.useFilter(instances, filter);
                } else {
                    filter = new Resample();
                    ((Resample)filter).setRandomSeed(Integer.parseInt(this.m_rseed.getText()));
                    ((Resample)filter).setSampleSizePercent(Double.parseDouble(this.m_resamplePercent.getText()));
                    ((Resample)filter).setInputFormat(this.m_data);
                    instances = Filter.useFilter(this.m_data, filter);
                }
            }
            catch (Exception exception) {
                System.out.println("Error occurred while sampling");
                exception.printStackTrace();
            }
        }
        this.m_points = new int[instances.numInstances()][this.m_selectedAttribs.length];
        this.m_pointColors = new int[instances.numInstances()];
        this.m_missing = new boolean[instances.numInstances()][this.m_selectedAttribs.length + 1];
        this.m_type = new int[2];
        this.jitterVals = new int[instances.numInstances()][2];
        if (!instances.attribute(this.m_classIndex).isNumeric()) {
            for (n3 = this.m_colorList.size(); n3 < instances.attribute(this.m_classIndex).numValues() + 1; ++n3) {
                Color color = m_defaultColors[n3 % 10];
                int n4 = n3 / 10;
                n4 *= 2;
                for (int i = 0; i < n4; ++i) {
                    color = color.darker();
                }
                this.m_colorList.addElement(color);
            }
            for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                this.m_pointColors[n3] = instances.instance(n3).isMissing(this.m_classIndex) ? m_defaultColors.length - 1 : (int)instances.instance(n3).value(this.m_classIndex);
                this.jitterVals[n3][0] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
                this.jitterVals[n3][1] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
            }
        } else {
            for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                if (instances.instance(n3).isMissing(this.m_classIndex)) continue;
                d = d2 = instances.instance(n3).value(this.m_classIndex);
                break;
            }
            for (n3 = 1; n3 < instances.numInstances(); ++n3) {
                if (instances.instance(n3).isMissing(this.m_classIndex)) continue;
                if (d > instances.instance(n3).value(this.m_classIndex)) {
                    d = instances.instance(n3).value(this.m_classIndex);
                }
                if (!(d2 < instances.instance(n3).value(this.m_classIndex))) continue;
                d2 = instances.instance(n3).value(this.m_classIndex);
            }
            for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                double d3 = (instances.instance(n3).value(this.m_classIndex) - d) / (d2 - d);
                d3 = d3 * 240.0 + 15.0;
                this.m_pointColors[n3] = (int)d3;
                this.jitterVals[n3][0] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
                this.jitterVals[n3][1] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
            }
        }
        double[] dArray = new double[this.m_selectedAttribs.length];
        double d4 = 0.0;
        double[] dArray2 = new double[this.m_selectedAttribs.length];
        double d5 = this.m_plotSize.getValue();
        double d6 = 0.0;
        double d7 = 0.0;
        for (n2 = 0; n2 < this.m_selectedAttribs.length; ++n2) {
            for (n = 0; n < instances.numInstances(); ++n) {
                d4 = 0.0;
                dArray[n2] = 0.0;
                if (instances.instance(n).isMissing(this.m_selectedAttribs[n2])) continue;
                dArray[n2] = d4 = instances.instance(n).value(this.m_selectedAttribs[n2]);
                break;
            }
            while (n < instances.numInstances()) {
                if (!instances.instance(n).isMissing(this.m_selectedAttribs[n2])) {
                    if (instances.instance(n).value(this.m_selectedAttribs[n2]) < dArray[n2]) {
                        dArray[n2] = instances.instance(n).value(this.m_selectedAttribs[n2]);
                    }
                    if (instances.instance(n).value(this.m_selectedAttribs[n2]) > d4) {
                        d4 = instances.instance(n).value(this.m_selectedAttribs[n2]);
                    }
                }
                ++n;
            }
            dArray2[n2] = d5 / (d4 - dArray[n2]);
        }
        n2 = 0;
        for (n = 0; n < this.m_selectedAttribs.length; ++n) {
            int n5;
            if (instances.attribute(this.m_selectedAttribs[n]).isNominal() || instances.attribute(this.m_selectedAttribs[n]).isString()) {
                d6 = d5 / (double)instances.attribute(this.m_selectedAttribs[n]).numValues();
                d7 = d6 / 2.0;
                for (n5 = 0; n5 < instances.numInstances(); ++n5) {
                    this.m_points[n5][n] = (int)Math.round(d7 + d6 * instances.instance(n5).value(this.m_selectedAttribs[n]));
                    if (!instances.instance(n5).isMissing(this.m_selectedAttribs[n])) continue;
                    this.m_missing[n5][n] = true;
                    if (this.m_selectedAttribs[n] != this.m_classIndex) continue;
                    this.m_missing[n5][this.m_missing[0].length - 1] = true;
                    n2 = 1;
                }
                continue;
            }
            for (n5 = 0; n5 < instances.numInstances(); ++n5) {
                this.m_points[n5][n] = (int)Math.round((instances.instance(n5).value(this.m_selectedAttribs[n]) - dArray[n]) * dArray2[n]);
                if (!instances.instance(n5).isMissing(this.m_selectedAttribs[n])) continue;
                this.m_missing[n5][n] = true;
                if (this.m_selectedAttribs[n] != this.m_classIndex) continue;
                this.m_missing[n5][this.m_missing[0].length - 1] = true;
                n2 = 1;
            }
        }
        if (instances.attribute(this.m_classIndex).isNominal() || instances.attribute(this.m_classIndex).isString()) {
            this.m_type[0] = 1;
            this.m_type[1] = instances.attribute(this.m_classIndex).numValues();
        } else {
            this.m_type[1] = 0;
            this.m_type[0] = 0;
        }
        if (n2 == 0) {
            for (n = 0; n < instances.numInstances(); ++n) {
                if (!instances.instance(n).isMissing(this.m_classIndex)) continue;
                this.m_missing[n][this.m_missing[0].length - 1] = true;
            }
        }
        this.m_cp.setColours(this.m_colorList);
    }

    public void setupAttribLists() {
        String[] stringArray = new String[this.m_data.numAttributes()];
        this.m_classAttrib.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            switch (this.m_data.attribute(i).type()) {
                case 1: {
                    string = " (Nom)";
                    break;
                }
                case 0: {
                    string = " (Num)";
                    break;
                }
                case 2: {
                    string = " (Str)";
                    break;
                }
                default: {
                    string = " (???)";
                }
            }
            stringArray[i] = new String("Colour: " + this.m_data.attribute(i).name() + " " + string);
            this.m_classAttrib.addItem(stringArray[i]);
        }
        this.m_classAttrib.setSelectedIndex(stringArray.length - 1);
        this.m_attribList.setListData(stringArray);
        this.m_attribList.setSelectionInterval(0, stringArray.length - 1);
    }

    public void setPercent() {
        if (this.m_data.numInstances() > 700) {
            String string = Double.toString(500.0 / (double)this.m_data.numInstances() * 100.0);
            if (string.indexOf(46) + 3 < string.length()) {
                this.m_resamplePercent.setText(string.substring(0, string.indexOf(46) - 1) + string.substring(string.indexOf(46), string.indexOf(46) + 3));
            } else {
                this.m_resamplePercent.setText(string);
            }
        } else {
            this.m_resamplePercent.setText("100");
        }
    }

    public void setInstances(Instances instances) {
        this.m_data = instances;
        this.setPercent();
        this.setupAttribLists();
        this.m_rseed.setText("1");
        this.origDist.setSelected(true);
        this.initInternalFields();
        this.m_cp.setInstances(this.m_data);
        this.m_cp.setCindex(this.m_classIndex);
        this.m_updateBt.doClick();
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("Weka Explorer: MatrixPanel");
        JButton jButton = new JButton("Set Instances");
        Instances instances = null;
        try {
            if (stringArray.length == 1) {
                instances = new Instances(new BufferedReader(new FileReader(stringArray[0])));
            } else {
                System.out.println("Usage: MatrixPanel <arff file>");
                System.exit(-1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        final MatrixPanel matrixPanel = new MatrixPanel();
        matrixPanel.setInstances(instances);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
                ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("arff", "Arff data files");
                jFileChooser.setFileFilter(extensionFileFilter);
                int n = jFileChooser.showOpenDialog(jFrame);
                if (n == 0) {
                    try {
                        System.out.println("You chose to open this file: " + jFileChooser.getSelectedFile().getName());
                        Instances instances = new Instances(new FileReader(jFileChooser.getSelectedFile().getAbsolutePath()));
                        matrixPanel.setInstances(instances);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)matrixPanel, "Center");
        jFrame.getContentPane().add((Component)jButton, "South");
        jFrame.getContentPane().setFont(new Font("SansSerif", 0, 11));
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
        jFrame.repaint();
    }

    private class Plot
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        int extpad = 3;
        int intpad = 4;
        int cellSize = 100;
        int cellRange = 100;
        int lastx = 0;
        int lasty = 0;
        int jitter = 0;
        Rectangle r;
        FontMetrics fm;
        int lastxpos;
        int lastypos;
        JPanel jPlColHeader;
        JPanel jPlRowHeader;

        public Plot() {
            this.setToolTipText("blah");
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.initialize();
        }

        public void initialize() {
            this.lastypos = 0;
            this.lastxpos = 0;
            this.cellRange = this.cellSize;
            this.cellSize = this.cellRange + 2 * this.intpad;
            this.jPlColHeader = new JPanel(this){
                Rectangle r;
                private final /* synthetic */ Plot this$1;
                {
                    this.this$1 = plot;
                }

                public void paint(Graphics graphics) {
                    this.r = graphics.getClipBounds();
                    graphics.clearRect(this.r.x, this.r.y, this.r.width, this.r.height);
                    graphics.setFont(MatrixPanel.access$1200(Plot.access$1100(this.this$1)));
                    this.this$1.fm = graphics.getFontMetrics();
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    graphics.setColor(MatrixPanel.access$1300(Plot.access$1100(this.this$1)));
                    n = this.this$1.extpad;
                    n2 = this.this$1.extpad + this.this$1.fm.getHeight();
                    for (int i = 0; i < MatrixPanel.access$200(Plot.access$1100(this.this$1)).length; ++i) {
                        if (n + this.this$1.cellSize < this.r.x) {
                            n += this.this$1.cellSize + this.this$1.extpad;
                            continue;
                        }
                        if (n > this.r.x + this.r.width) break;
                        n3 = this.this$1.fm.stringWidth(Plot.access$1100((Plot)this.this$1).m_data.attribute(MatrixPanel.access$200(Plot.access$1100(this.this$1))[i]).name());
                        graphics.drawString(Plot.access$1100((Plot)this.this$1).m_data.attribute(MatrixPanel.access$200(Plot.access$1100(this.this$1))[i]).name(), n3 < this.this$1.cellSize ? n + (this.this$1.cellSize / 2 - n3 / 2) : n, n2);
                        n += this.this$1.cellSize + this.this$1.extpad;
                    }
                    this.this$1.fm = null;
                    this.r = null;
                }

                public Dimension getPreferredSize() {
                    this.this$1.fm = this.getFontMetrics(this.getFont());
                    return new Dimension(MatrixPanel.access$200(Plot.access$1100(this.this$1)).length * (this.this$1.cellSize + this.this$1.extpad), 2 * this.this$1.extpad + this.this$1.fm.getHeight());
                }
            };
            this.jPlRowHeader = new JPanel(this){
                Rectangle r;
                private final /* synthetic */ Plot this$1;
                {
                    this.this$1 = plot;
                }

                public void paint(Graphics graphics) {
                    this.r = graphics.getClipBounds();
                    graphics.clearRect(this.r.x, this.r.y, this.r.width, this.r.height);
                    graphics.setFont(MatrixPanel.access$1200(Plot.access$1100(this.this$1)));
                    this.this$1.fm = graphics.getFontMetrics();
                    int n = 0;
                    int n2 = 0;
                    boolean bl = false;
                    graphics.setColor(MatrixPanel.access$1300(Plot.access$1100(this.this$1)));
                    n = this.this$1.extpad;
                    n2 = this.this$1.extpad;
                    for (int i = MatrixPanel.access$200(Plot.access$1100(this.this$1)).length - 1; i >= 0; --i) {
                        if (n2 + this.this$1.cellSize < this.r.y) {
                            n2 += this.this$1.cellSize + this.this$1.extpad;
                            continue;
                        }
                        if (n2 > this.r.y + this.r.height) break;
                        graphics.drawString(Plot.access$1100((Plot)this.this$1).m_data.attribute(MatrixPanel.access$200(Plot.access$1100(this.this$1))[i]).name(), n + this.this$1.extpad, n2 + this.this$1.cellSize / 2);
                        n = this.this$1.extpad;
                        n2 += this.this$1.cellSize + this.this$1.extpad;
                    }
                    this.r = null;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(100 + this.this$1.extpad, MatrixPanel.access$200(Plot.access$1100(this.this$1)).length * (this.this$1.cellSize + this.this$1.extpad));
                }
            };
            this.jPlColHeader.setFont(MatrixPanel.this.f);
            this.jPlRowHeader.setFont(MatrixPanel.this.f);
            this.setFont(MatrixPanel.this.f);
        }

        public JPanel getRowHeader() {
            return this.jPlRowHeader;
        }

        public JPanel getColHeader() {
            return this.jPlColHeader;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Graphics graphics = this.getGraphics();
            int n = this.extpad;
            int n2 = this.extpad;
            for (int i = MatrixPanel.this.m_selectedAttribs.length - 1; i >= 0; --i) {
                for (int j = 0; j < MatrixPanel.this.m_selectedAttribs.length; ++j) {
                    if (mouseEvent.getX() >= n && mouseEvent.getX() <= n + this.cellSize + this.extpad && mouseEvent.getY() >= n2 && mouseEvent.getY() <= n2 + this.cellSize + this.extpad) {
                        if (n != this.lastxpos || n2 != this.lastypos) {
                            graphics.setColor(Color.red);
                            graphics.drawRect(n - 1, n2 - 1, this.cellSize + 1, this.cellSize + 1);
                            if (this.lastxpos != 0 && this.lastypos != 0) {
                                graphics.setColor(this.getBackground().darker());
                                graphics.drawRect(this.lastxpos - 1, this.lastypos - 1, this.cellSize + 1, this.cellSize + 1);
                            }
                            this.lastxpos = n;
                            this.lastypos = n2;
                        }
                        return;
                    }
                    n += this.cellSize + this.extpad;
                }
                n = this.extpad;
                n2 += this.cellSize + this.extpad;
            }
            if (this.lastxpos != 0 && this.lastypos != 0) {
                graphics.setColor(this.getBackground().darker());
                graphics.drawRect(this.lastxpos - 1, this.lastypos - 1, this.cellSize + 1, this.cellSize + 1);
            }
            this.lastypos = 0;
            this.lastxpos = 0;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            int n3 = this.extpad;
            int n4 = this.extpad;
            for (n2 = MatrixPanel.this.m_selectedAttribs.length - 1; n2 >= 0; --n2) {
                for (n = 0; n < MatrixPanel.this.m_selectedAttribs.length; ++n) {
                    if (mouseEvent.getX() >= n3 && mouseEvent.getX() <= n3 + this.cellSize + this.extpad && mouseEvent.getY() >= n4 && mouseEvent.getY() <= n4 + this.cellSize + this.extpad) {
                        bl = true;
                        break;
                    }
                    n3 += this.cellSize + this.extpad;
                }
                if (bl) break;
                n3 = this.extpad;
                n4 += this.cellSize + this.extpad;
            }
            if (!bl) {
                return;
            }
            JFrame jFrame = new JFrame("Weka Explorer: Visualizing " + MatrixPanel.this.m_data.relationName());
            VisualizePanel visualizePanel = new VisualizePanel();
            try {
                PlotData2D plotData2D = new PlotData2D(MatrixPanel.this.m_data);
                plotData2D.setPlotName("Master Plot");
                visualizePanel.setMasterPlot(plotData2D);
                visualizePanel.setXIndex(MatrixPanel.this.m_selectedAttribs[n]);
                visualizePanel.setYIndex(MatrixPanel.this.m_selectedAttribs[n2]);
                visualizePanel.m_ColourCombo.setSelectedIndex(MatrixPanel.this.m_classIndex);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            jFrame.getContentPane().add(visualizePanel);
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void setJitter(int n) {
            this.jitter = n;
        }

        public void setCellSize(int n) {
            this.cellSize = n;
            this.initialize();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.extpad;
            int n2 = this.extpad;
            for (int i = MatrixPanel.this.m_selectedAttribs.length - 1; i >= 0; --i) {
                for (int j = 0; j < MatrixPanel.this.m_selectedAttribs.length; ++j) {
                    if (mouseEvent.getX() >= n && mouseEvent.getX() <= n + this.cellSize + this.extpad && mouseEvent.getY() >= n2 && mouseEvent.getY() <= n2 + this.cellSize + this.extpad) {
                        return "X: " + MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[j]).name() + " Y: " + MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[i]).name() + " (click to enlarge)";
                    }
                    n += this.cellSize + this.extpad;
                }
                n = this.extpad;
                n2 += this.cellSize + this.extpad;
            }
            return "Matrix Panel";
        }

        public void paintGraph(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.getBackground().darker().darker());
            graphics.drawRect(n3 - 1, n4 - 1, this.cellSize + 1, this.cellSize + 1);
            graphics.setColor(Color.white);
            graphics.fillRect(n3, n4, this.cellSize, this.cellSize);
            for (int i = 0; i < MatrixPanel.this.m_points.length; ++i) {
                int n5;
                int n6;
                if (MatrixPanel.this.m_missing[i][n2] || MatrixPanel.this.m_missing[i][n]) continue;
                if (MatrixPanel.this.m_type[0] == 0) {
                    if (MatrixPanel.this.m_missing[i][MatrixPanel.this.m_missing[0].length - 1]) {
                        graphics.setColor(m_defaultColors[m_defaultColors.length - 1]);
                    } else {
                        graphics.setColor(new Color(MatrixPanel.this.m_pointColors[i], 150, 255 - MatrixPanel.this.m_pointColors[i]));
                    }
                } else {
                    graphics.setColor((Color)MatrixPanel.this.m_colorList.elementAt(MatrixPanel.this.m_pointColors[i]));
                }
                if (MatrixPanel.this.m_points[i][n] + MatrixPanel.this.jitterVals[i][0] < 0 || MatrixPanel.this.m_points[i][n] + MatrixPanel.this.jitterVals[i][0] > this.cellRange) {
                    if (this.cellRange - MatrixPanel.this.m_points[i][n2] + MatrixPanel.this.jitterVals[i][1] < 0 || this.cellRange - MatrixPanel.this.m_points[i][n2] + MatrixPanel.this.jitterVals[i][1] > this.cellRange) {
                        n6 = this.intpad + MatrixPanel.this.m_points[i][n];
                        n5 = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][n2]);
                    } else {
                        n6 = this.intpad + MatrixPanel.this.m_points[i][n];
                        n5 = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][n2]) + MatrixPanel.this.jitterVals[i][1];
                    }
                } else if (this.cellRange - MatrixPanel.this.m_points[i][n2] + MatrixPanel.this.jitterVals[i][1] < 0 || this.cellRange - MatrixPanel.this.m_points[i][n2] + MatrixPanel.this.jitterVals[i][1] > this.cellRange) {
                    n6 = this.intpad + MatrixPanel.this.m_points[i][n] + MatrixPanel.this.jitterVals[i][0];
                    n5 = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][n2]);
                } else {
                    n6 = this.intpad + MatrixPanel.this.m_points[i][n] + MatrixPanel.this.jitterVals[i][0];
                    n5 = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][n2]) + MatrixPanel.this.jitterVals[i][1];
                }
                if (MatrixPanel.this.datapointSize == 1) {
                    graphics.drawLine(n6 + n3, n5 + n4, n6 + n3, n5 + n4);
                    continue;
                }
                graphics.drawOval(n6 + n3 - MatrixPanel.this.datapointSize / 2, n5 + n4 - MatrixPanel.this.datapointSize / 2, MatrixPanel.this.datapointSize, MatrixPanel.this.datapointSize);
            }
            graphics.setColor(MatrixPanel.this.fontColor);
        }

        public void paintME(Graphics graphics) {
            this.r = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
            graphics.setColor(MatrixPanel.this.fontColor);
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            n = this.extpad;
            n2 = this.extpad;
            for (int i = MatrixPanel.this.m_selectedAttribs.length - 1; i >= 0; --i) {
                if (n2 + this.cellSize < this.r.y) {
                    n2 += this.cellSize + this.extpad;
                    continue;
                }
                if (n2 > this.r.y + this.r.height) break;
                for (int j = 0; j < MatrixPanel.this.m_selectedAttribs.length; ++j) {
                    if (n + this.cellSize < this.r.x) {
                        n += this.cellSize + this.extpad;
                        continue;
                    }
                    if (n > this.r.x + this.r.width) break;
                    this.paintGraph(graphics, j, i, n, n2);
                    n += this.cellSize + this.extpad;
                }
                n = this.extpad;
                n2 += this.cellSize + this.extpad;
            }
        }

        public void paintComponent(Graphics graphics) {
            this.paintME(graphics);
        }

        static /* synthetic */ MatrixPanel access$1100(Plot plot) {
            return plot.MatrixPanel.this;
        }
    }
}

