/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects;

import com.mockobjects.AbstractExpectation;
import com.mockobjects.util.AssertMo;

public class ExpectationDoubleValue
extends AbstractExpectation {
    private Double expectedValue = null;
    private double expectedError = 0.0;
    private boolean expectNothing = false;
    private Double actualValue = null;

    public ExpectationDoubleValue(String name) {
        super(name);
        this.clearActual();
    }

    public void clearActual() {
        this.actualValue = null;
    }

    public void setActual(double value) {
        this.actualValue = new Double(value);
        if (this.shouldCheckImmediately()) {
            this.verify();
        }
    }

    public void setExpected(double value, double error) {
        this.expectedValue = new Double(value);
        this.expectedError = Math.abs(error);
        this.setHasExpectations();
    }

    public void setExpectNothing() {
        this.expectNothing = true;
        this.clearActual();
        this.setHasExpectations();
    }

    public void verify() {
        if (this.expectNothing) {
            AssertMo.assertNull((String)(this.myName + " expected no value"), (Object)this.actualValue);
        } else if (this.expectedValue != null) {
            AssertMo.assertNotNull((String)(this.myName + " expected a value"), (Object)this.actualValue);
            double actualError = Math.abs(this.actualValue - this.expectedValue);
            AssertMo.assertTrue((String)(this.myName + " expected a value within " + this.expectedError + " of " + this.expectedValue + ", was " + this.actualValue), (actualError <= this.expectedError ? 1 : 0) != 0);
        }
    }
}

