/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects;

import com.mockobjects.util.Null;
import java.lang.reflect.Array;
import java.util.Map;

public class MapEntry
implements Map.Entry {
    private Object myKey;
    private Object myValue;

    public MapEntry(Object aKey, Object aValue) {
        this.myKey = aKey == null ? new Null() : aKey;
        this.myValue = aValue == null ? new Null() : aValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapEntry)) {
            return false;
        }
        MapEntry other = (MapEntry)o;
        if (this.myValue.getClass().isArray() && other.getValue().getClass().isArray()) {
            return this.arrayEquals(other.getValue());
        }
        return this.myKey.equals(other.getKey()) && this.myValue.equals(other.getValue());
    }

    private final boolean arrayEquals(Object anArray) {
        int i = 0;
        boolean endOfThisArray = false;
        boolean endOfAnotherArray = false;
        while (true) {
            Object valueOfThis = null;
            Object valueOfAnother = null;
            try {
                valueOfThis = Array.get(this.myValue, i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                endOfThisArray = true;
            }
            try {
                valueOfAnother = Array.get(anArray, i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                endOfAnotherArray = true;
            }
            if (endOfThisArray && endOfAnotherArray) {
                return true;
            }
            if (!(valueOfThis == null && valueOfAnother == null || valueOfThis != null && valueOfThis.equals(valueOfAnother))) {
                return false;
            }
            ++i;
        }
    }

    public Object getKey() {
        return this.myKey;
    }

    public Object getValue() {
        return this.myValue;
    }

    public int hashCode() {
        int hash = this.myKey.hashCode();
        if (this.myValue.getClass().isArray()) {
            int i = 0;
            try {
                while (true) {
                    hash ^= Array.get(this.myValue, i++).hashCode();
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            hash ^= this.myValue.hashCode();
        }
        return hash;
    }

    public Object setValue(Object aValue) {
        Object oldValue = this.myValue;
        this.myValue = null == aValue ? new Null() : aValue;
        return oldValue;
    }

    public String toString() {
        return this.myKey.toString() + "=" + this.myValue.toString();
    }
}

