/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.generate;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.annogen.generate.internal.joust.FileWriterFactory;
import org.codehaus.annogen.generate.internal.joust.JavaOutputStream;
import org.codehaus.annogen.generate.internal.joust.SourceJavaOutputStream;
import org.codehaus.annogen.generate.internal.joust.Variable;
import org.codehaus.annogen.override.internal.AnnoBeanBase;
import org.codehaus.annogen.view.internal.reflect.ReflectAnnogenTigerDelegate;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JAnnotationValue;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;
import org.codehaus.jam.internal.JamLoggerImpl;

public class Annogen {
    public static final String SETTER_PREFIX = "set_";
    private static final String FIELD_PREFIX = "_";
    private static final String BASE_CLASS = AnnoBeanBase.class.getName();
    private static final String ANNOGENINFO_ANNOBEAN_CLASSNAME = "annoBeanClass";
    private List mClassesLeftTodo = null;
    private Collection mClassesDone = null;
    private JavaOutputStream mJoust = null;
    private Map mDeclaredJclass2beanClassname = new HashMap();
    private boolean mImplementAnnotationTypes = true;
    private ReflectAnnogenTigerDelegate mTiger = ReflectAnnogenTigerDelegate.create(new JamLoggerImpl());

    public static void main(String[] args) {
        try {
            JamServiceFactory jsf = JamServiceFactory.getInstance();
            JamServiceParams params = jsf.createServiceParams();
            Annogen ag = new Annogen();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-d")) {
                    ag.setOutputDir(new File(args[++i]));
                    ++i;
                    continue;
                }
                File f = new File(args[i]);
                if (f.isDirectory()) {
                    File[] fs = f.listFiles();
                    for (int j = 0; j < fs.length; ++j) {
                        params.includeSourceFile(fs[j]);
                    }
                    continue;
                }
                params.includeSourceFile(f);
            }
            JamService js = jsf.createService(params);
            ag.addAnnotationClasses(js.getAllClasses());
            ag.doCodegen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.flush();
            System.exit(-1);
        }
    }

    public Annogen() {
        if (this.mTiger == null) {
            throw new IllegalStateException("The annogen code generator must be run under JDK 1.5 or later.");
        }
        this.mClassesLeftTodo = new LinkedList();
        this.mClassesDone = new HashSet();
    }

    public void addAnnotationClasses(JClass[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isAnnotationType()) {
                JAnnotation ann = classes[i].getAnnotation(this.mTiger.getAnnogenInfoClass());
                if (ann == null) {
                    this.warn("Ignoring " + classes[i].getQualifiedName() + " because it does not declare an @AnnogenInfo annotation.");
                    continue;
                }
                JAnnotationValue val = ann.getValue(ANNOGENINFO_ANNOBEAN_CLASSNAME);
                if (val == null) {
                    this.warn("Ignoring " + classes[i].getQualifiedName() + " because its @AnnogenInfo annotation does specify an " + ANNOGENINFO_ANNOBEAN_CLASSNAME);
                    continue;
                }
                this.mDeclaredJclass2beanClassname.put(classes[i], val.asString());
                this.mClassesLeftTodo.add(classes[i]);
                continue;
            }
            this.warn("Ignoring " + classes[i].getQualifiedName() + " because it is not an annotation type.");
        }
    }

    public void setOutputDir(File dir) {
        FileWriterFactory wf = new FileWriterFactory(dir);
        this.setJavaOutputStream(new SourceJavaOutputStream(wf));
    }

    public void setJavaOutputStream(JavaOutputStream joust) {
        this.mJoust = joust;
    }

    public void doCodegen() throws IOException {
        while (this.mClassesLeftTodo.size() > 0) {
            JClass clazz = (JClass)this.mClassesLeftTodo.get(0);
            this.mClassesLeftTodo.remove(0);
            this.mClassesDone.add(clazz);
            this.doCodegen(clazz);
        }
    }

    public void setPre15CompatibilityMode(boolean b) {
        this.mImplementAnnotationTypes = b;
    }

    private void doCodegen(JClass clazz) throws IOException {
        String[] stringArray;
        String annoBeanClassname = this.getAnnoBeanClassnameFor(clazz);
        if (annoBeanClassname == null) {
            throw new IllegalStateException();
        }
        int lastDot = annoBeanClassname.lastIndexOf(46);
        String simpleImplName = lastDot == -1 ? annoBeanClassname : annoBeanClassname.substring(lastDot + 1);
        String packageName = lastDot == -1 ? null : annoBeanClassname.substring(0, lastDot);
        this.mJoust.startFile(packageName, simpleImplName);
        JMethod[] methods = clazz.getDeclaredMethods();
        if (!this.mImplementAnnotationTypes) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = clazz.getQualifiedName();
        }
        String[] implementInterface = stringArray;
        this.mJoust.writeComment("THIS IS GENERATED CODE! DO NOT EDIT!\n\n\nGenerated by " + this.getClass().getName() + "\n on " + new Date() + "\n" + "\n");
        this.mJoust.startClass(1, BASE_CLASS, implementInterface);
        this.mJoust.writeField(25, "java.lang.String", "PROXY_FOR", this.mJoust.getExpressionFactory().createString(clazz.getQualifiedName()));
        for (int i = 0; i < methods.length; ++i) {
            String fieldName = FIELD_PREFIX + methods[i].getSimpleName();
            JClass type = methods[i].getReturnType();
            String typeName = !this.mImplementAnnotationTypes ? this.getImplClassForIfGenerated(type) : type.getQualifiedName();
            Variable fieldVar = this.mJoust.writeField(2, typeName, fieldName, null);
            this.mJoust.startMethod(1, typeName, methods[i].getSimpleName(), null, null, null);
            this.mJoust.writeReturnStatement(fieldVar);
            this.mJoust.endMethodOrConstructor();
            String[] paramTypeNames = new String[]{typeName};
            String[] paramNames = new String[]{"in"};
            Variable[] params = this.mJoust.startMethod(1, "void", SETTER_PREFIX + methods[i].getSimpleName(), paramTypeNames, paramNames, null);
            this.mJoust.writeAssignmentStatement(fieldVar, params[0]);
            this.mJoust.endMethodOrConstructor();
            JClass c = clazz.forName(typeName);
            if (!c.isAnnotationType() || this.mClassesLeftTodo.contains(c) || this.mClassesDone.contains(c)) continue;
            this.mClassesLeftTodo.add(c);
        }
        this.mJoust.endClassOrInterface();
        this.mJoust.endFile();
    }

    private void warn(String msg) {
        System.out.println("[Warning] " + msg);
    }

    private String getImplClassForIfGenerated(JClass clazz) {
        if (clazz.isArrayType()) {
            JClass comp = clazz.getArrayComponentType();
            StringWriter out = new StringWriter();
            out.write(this.getImplClassForIfGenerated(comp));
            for (int i = 0; i < clazz.getArrayDimensions(); ++i) {
                out.write("[]");
            }
            return out.toString();
        }
        if (this.mClassesLeftTodo.contains(clazz) || this.mClassesDone.contains(clazz)) {
            return this.getAnnoBeanClassnameFor(clazz);
        }
        return clazz.getQualifiedName();
    }

    private String getAnnoBeanClassnameFor(JClass clazz) {
        return (String)this.mDeclaredJclass2beanClassname.get(clazz);
    }
}

