/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class StackWindow
extends ImageWindow
implements Runnable,
AdjustmentListener,
ActionListener {
    protected Scrollbar sliceSelector;
    protected Thread thread;
    protected boolean done;
    protected int slice;

    public StackWindow(ImagePlus imp) {
        this(imp, new ImageCanvas(imp));
    }

    public StackWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp, ic);
        ImageStack s = imp.getStack();
        int stackSize = s.getSize();
        this.sliceSelector = new Scrollbar(0, 1, 1, 1, stackSize + 1);
        this.add(this.sliceSelector);
        this.sliceSelector.addAdjustmentListener(this);
        int blockIncrement = stackSize / 10;
        if (blockIncrement < 1) {
            blockIncrement = 1;
        }
        this.sliceSelector.setUnitIncrement(1);
        this.sliceSelector.setBlockIncrement(blockIncrement);
        this.pack();
        this.show();
        int previousSlice = imp.getCurrentSlice();
        imp.setSlice(1);
        if (previousSlice > 1 && previousSlice <= stackSize) {
            imp.setSlice(previousSlice);
        }
        this.thread = new Thread((Runnable)this, "SliceSelector");
        this.thread.start();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.running) {
            this.slice = this.sliceSelector.getValue();
            this.notify();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public boolean close() {
        if (!super.close()) {
            return false;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int index) {
        if (index >= 1 && index <= this.imp.getStackSize()) {
            this.imp.setSlice(index);
        }
    }

    public void updateSliceSelector() {
        int stackSize = this.imp.getStackSize();
        int max = this.sliceSelector.getMaximum();
        if (max != stackSize + 1) {
            this.sliceSelector.setMaximum(stackSize + 1);
        }
        this.sliceSelector.setValue(this.imp.getCurrentSlice());
    }

    public void run() {
        while (!this.done) {
            StackWindow stackWindow = this;
            synchronized (stackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int s = this.slice;
            this.slice = 0;
            if (s == this.imp.getCurrentSlice()) continue;
            this.imp.setSlice(s);
        }
    }
}

