/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.gui.GUI;
import ij.plugin.frame.Recorder;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

public class OpenDialog {
    private String dir;
    private String name;
    private boolean recordPath;
    private static String defaultDirectory;
    private static Frame sharedFrame;
    private String title;
    static /* synthetic */ Class class$ij$io$OpenDialog;

    public OpenDialog(String title, String path) {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && (path == null || path.equals("")) && ((path = Macro.getValue(macroOptions, title, path)) == null || path.equals(""))) {
            path = Macro.getValue(macroOptions, "path", path);
        }
        if (path == null || path.equals("")) {
            if (Prefs.useJFileChooser) {
                this.jOpen(title, OpenDialog.getDefaultDirectory(), null);
            } else {
                this.open(title, OpenDialog.getDefaultDirectory(), null);
            }
            if (this.name != null) {
                defaultDirectory = this.dir;
            }
            this.title = title;
            this.recordPath = true;
        } else {
            this.decodePath(path);
            this.recordPath = IJ.macroRunning();
        }
        IJ.register(class$ij$io$OpenDialog == null ? (class$ij$io$OpenDialog = OpenDialog.class$("ij.io.OpenDialog")) : class$ij$io$OpenDialog);
    }

    public OpenDialog(String title, String defaultDir, String defaultName) {
        String path = null;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            path = Macro.getValue(macroOptions, title, path);
        }
        if (path != null) {
            this.decodePath(path);
        } else {
            if (Prefs.useJFileChooser) {
                this.jOpen(title, defaultDir, defaultName);
            } else {
                this.open(title, defaultDir, defaultName);
            }
            this.title = title;
            this.recordPath = true;
        }
    }

    void jOpen(String title, String path, String fileName) {
        int returnVal;
        JFileChooser fc = new JFileChooser();
        File fdir = null;
        if (path != null) {
            fdir = new File(path);
        }
        if (fdir != null) {
            fc.setCurrentDirectory(fdir);
        }
        if (fileName != null) {
            fc.setSelectedFile(new File(fileName));
        }
        if ((returnVal = fc.showOpenDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File file = fc.getSelectedFile();
        if (file == null) {
            Macro.abort();
            return;
        }
        this.name = file.getName();
        this.dir = fc.getCurrentDirectory().getPath() + File.separator;
    }

    void open(String title, String path, String fileName) {
        Frame parent = IJ.getInstance();
        if (parent == null) {
            if (sharedFrame == null) {
                sharedFrame = new Frame();
            }
            parent = sharedFrame;
        }
        FileDialog fd = new FileDialog(parent, title);
        if (path != null) {
            fd.setDirectory(path);
        }
        if (fileName != null) {
            fd.setFile(fileName);
        }
        GUI.center(fd);
        fd.show();
        this.name = fd.getFile();
        if (this.name == null) {
            Macro.abort();
        } else {
            this.dir = fd.getDirectory();
        }
    }

    void decodePath(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            this.dir = path.substring(0, i + 1);
            this.name = path.substring(i + 1);
        } else {
            this.dir = "";
            this.name = path;
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record && this.recordPath) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        return this.name;
    }

    public static String getDefaultDirectory() {
        if (defaultDirectory == null) {
            defaultDirectory = Prefs.getString("dir.image");
        }
        return defaultDirectory;
    }

    static void setDefaultDirectory(String defaultDir) {
        defaultDirectory = defaultDir;
        IJ.register(class$ij$io$OpenDialog == null ? (class$ij$io$OpenDialog = OpenDialog.class$("ij.io.OpenDialog")) : class$ij$io$OpenDialog);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

