/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Histogram
implements PlugIn,
TextListener {
    private static int nBins = 256;
    private static boolean useImageMinAndMax = true;
    private static double histMin;
    private static double histMax;
    private static int imageID;
    private Checkbox checkbox;
    private TextField minField;
    private TextField maxField;
    private String defaultMin;
    private String defaultMax;
    static /* synthetic */ Class class$ij$plugin$Histogram;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp.getBitDepth() == 32) {
            if (!this.showDialog(imp)) {
                return;
            }
        } else {
            nBins = 256;
            histMin = 0.0;
            histMax = 0.0;
        }
        if (useImageMinAndMax) {
            new HistogramWindow("Histogram of " + imp.getShortTitle(), imp, nBins, 0.0, 0.0);
        } else {
            new HistogramWindow("Histogram of " + imp.getShortTitle(), imp, nBins, histMin, histMax);
        }
    }

    boolean showDialog(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        if (imp.getID() != imageID || min == histMin && min == histMax) {
            useImageMinAndMax = true;
        }
        if (imp.getID() != imageID || useImageMinAndMax) {
            histMin = min;
            histMax = max;
        }
        this.defaultMin = IJ.d2s(histMin, 2);
        this.defaultMax = IJ.d2s(histMax, 2);
        imageID = imp.getID();
        GenericDialog gd = new GenericDialog("Histogram");
        gd.addNumericField("Number of Bins:", HistogramWindow.nBins, 0);
        gd.addCheckbox("Use Image Min and Max", useImageMinAndMax);
        gd.addMessage("          or");
        gd.addMessage("");
        gd.addNumericField("Histogram_Min:", histMin, 2);
        gd.addNumericField("Histogram_Max:", histMax, 2);
        Vector numbers = gd.getNumericFields();
        this.minField = (TextField)numbers.elementAt(1);
        this.minField.addTextListener(this);
        this.maxField = (TextField)numbers.elementAt(2);
        this.maxField.addTextListener(this);
        this.checkbox = (Checkbox)gd.checkbox.elementAt(0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        nBins = (int)gd.getNextNumber();
        if (nBins >= 2 && nBins <= 1000) {
            HistogramWindow.nBins = nBins;
        }
        useImageMinAndMax = gd.getNextBoolean();
        histMin = gd.getNextNumber();
        histMax = gd.getNextNumber();
        IJ.register(class$ij$plugin$Histogram == null ? (class$ij$plugin$Histogram = Histogram.class$("ij.plugin.Histogram")) : class$ij$plugin$Histogram);
        return true;
    }

    public void textValueChanged(TextEvent e) {
        boolean rangeChanged;
        boolean bl = rangeChanged = !this.defaultMin.equals(this.minField.getText()) || !this.defaultMax.equals(this.maxField.getText());
        if (rangeChanged) {
            this.checkbox.setState(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

