/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Slicer
implements PlugIn {
    private static final String[] starts = new String[]{"Top", "Left", "Bottom", "Right"};
    private static String startAt = starts[0];
    private static boolean rotate;
    private static boolean flip;
    private double outputZSpacing = 1.0;
    private int outputSlices = 1;
    private ImageWindow win;
    private boolean noRoi;
    private boolean rgb;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        int stackSize = imp.getStackSize();
        if (stackSize < 2) {
            IJ.showMessage("Reslicer", "Stack required");
            return;
        }
        if (!this.showDialog(imp)) {
            return;
        }
        IJ.showStatus("Reslice... (press esc to abort)");
        this.win = imp.getWindow();
        if (this.win != null) {
            this.win.running = true;
        }
        long startTime = System.currentTimeMillis();
        ImagePlus imp2 = null;
        this.rgb = imp.getType() == 4;
        imp2 = this.reslice(imp);
        if (imp2 == null) {
            return;
        }
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        cal.pixelDepth = this.outputZSpacing * cal.pixelWidth;
        imp2.show();
        if (this.noRoi) {
            imp.killRoi();
        } else {
            imp.draw();
        }
        if (this.win != null) {
            this.win.running = false;
        }
        IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - startTime) / 1000.0, 2) + " seconds");
    }

    public ImagePlus reslice(ImagePlus imp) {
        int roiType;
        Roi roi = imp.getRoi();
        int n = roiType = roi != null ? roi.getType() : 0;
        if (roi == null || roiType == 0 || roiType == 5) {
            return this.resliceRectOrLine(imp);
        }
        if (roiType == 6 || roiType == 7) {
            String status = imp.getStack().isVirtual() ? "" : null;
            ImageProcessor ip2 = this.getSlice(imp, 0.0, 0.0, 0.0, 0.0, status);
            return new ImagePlus("Reslice of  " + imp.getShortTitle(), ip2);
        }
        IJ.showMessage("Reslice...", "Line or rectangular selection required");
        return null;
    }

    boolean showDialog(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        String units = cal.getUnits();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        double outputSpacing = cal.pixelDepth;
        Roi roi = imp.getRoi();
        boolean line = roi != null && roi.getType() == 5;
        GenericDialog gd = new GenericDialog("Reslice");
        gd.addNumericField("Input Z Spacing (" + units + "):", cal.pixelDepth, 3);
        gd.addNumericField("Output Z Spacing (" + units + "):", outputSpacing, 3);
        if (line) {
            gd.addNumericField("Slice Count:", this.outputSlices, 0);
        } else {
            gd.addChoice("Start At:", starts, startAt);
        }
        gd.addCheckbox("Flip Vertically", flip);
        gd.addCheckbox("Rotate 90 Degrees", rotate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        cal.pixelDepth = gd.getNextNumber();
        if (cal.pixelDepth == 0.0) {
            cal.pixelDepth = 1.0;
        }
        this.outputZSpacing = gd.getNextNumber() / cal.pixelWidth;
        if (line) {
            this.outputSlices = (int)gd.getNextNumber();
        } else {
            startAt = gd.getNextChoice();
        }
        flip = gd.getNextBoolean();
        rotate = gd.getNextBoolean();
        return true;
    }

    ImagePlus resliceRectOrLine(ImagePlus imp) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xInc = 0.0;
        double yInc = 0.0;
        this.noRoi = false;
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi = true;
            imp.setRoi(0, 0, imp.getWidth(), imp.getHeight());
            roi = imp.getRoi();
        }
        if (roi.getType() == 0) {
            Rectangle r = roi.getBoundingRect();
            if (startAt.equals(starts[0])) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y;
                xInc = 0.0;
                yInc = this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startAt.equals(starts[1])) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x;
                y2 = r.y + r.height;
                xInc = this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            } else if (startAt.equals(starts[2])) {
                x1 = r.x;
                y1 = r.y + r.height;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = 0.0;
                yInc = -this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startAt.equals(starts[3])) {
                x1 = r.x + r.width;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = -this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            }
        } else if (roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1;
            y1 = line.y1;
            x2 = line.x2;
            y2 = line.y2;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double nrm = Math.sqrt(dx * dx + dy * dy) / this.outputZSpacing;
            xInc = -(dy / nrm);
            yInc = dx / nrm;
        } else {
            return null;
        }
        if (this.outputSlices == 0) {
            IJ.showMessage("Reslicer", "Output Z spacing (" + IJ.d2s(this.outputZSpacing, 0) + " pixels) is too large.");
            return null;
        }
        ImageStack stack = null;
        boolean virtualStack = imp.getStack().isVirtual();
        String status = null;
        int i = 0;
        while (i < this.outputSlices) {
            if (virtualStack) {
                status = this.outputSlices > 1 ? i + 1 + "/" + this.outputSlices + ", " : "";
            }
            ImageProcessor ip = this.getSlice(imp, x1, y1, x2, y2, status);
            this.drawLine(x1, y1, x2, y2, imp);
            if (stack == null) {
                stack = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            stack.addSlice(null, ip);
            x1 += xInc;
            x2 += xInc;
            y1 += yInc;
            y2 += yInc;
            if (this.win != null && !this.win.running) {
                IJ.beep();
                imp.draw();
                return null;
            }
            ++i;
        }
        return new ImagePlus("Reslice of  " + imp.getShortTitle(), stack);
    }

    ImageProcessor getSlice(ImagePlus imp, double x1, double y1, double x2, double y2, String status) {
        Roi roi = imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        ImageStack stack = imp.getStack();
        int stackSize = stack.getSize();
        ImageProcessor ip2 = null;
        float[] line = null;
        int i = 0;
        while (i < stackSize) {
            ImageProcessor ip = stack.getProcessor(flip ? stackSize - i : i + 1);
            line = roiType == 6 || roiType == 7 ? this.getIrregularProfile(roi, ip) : this.getLine(ip, x1, y1, x2, y2, line);
            if (rotate) {
                if (i == 0) {
                    ip2 = ip.createProcessor(stackSize, line.length);
                }
                this.putColumn(ip2, i, 0, line, line.length);
            } else {
                if (i == 0) {
                    ip2 = ip.createProcessor(line.length, stackSize);
                }
                this.putRow(ip2, 0, i, line, line.length);
            }
            if (status != null) {
                IJ.showStatus("Slicing: " + status + i + "/" + stackSize);
            }
            ++i;
        }
        Calibration cal = imp.getCalibration();
        double zSpacing = cal.pixelDepth / cal.pixelWidth;
        if (zSpacing != 1.0) {
            ip2.setInterpolate(true);
            ip2 = rotate ? ip2.resize((int)((double)stackSize * zSpacing), line.length) : ip2.resize(line.length, (int)((double)stackSize * zSpacing));
        }
        return ip2;
    }

    public void putRow(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            int i = 0;
            while (i < length) {
                ip.putPixel(x++, y, Float.floatToIntBits(data[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                ip.putPixelValue(x++, y, data[i]);
                ++i;
            }
        }
    }

    public void putColumn(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            int i = 0;
            while (i < length) {
                ip.putPixel(x, y++, Float.floatToIntBits(data[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                ip.putPixelValue(x, y++, data[i]);
                ++i;
            }
        }
    }

    float[] getIrregularProfile(Roi roi, ImageProcessor ip) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] x = ((PolygonRoi)roi).getXCoordinates();
        int[] y = ((PolygonRoi)roi).getYCoordinates();
        Rectangle r = roi.getBoundingRect();
        int xbase = r.x;
        int ybase = r.y;
        double length = 0.0;
        double[] segmentLengths = new double[n];
        int[] dx = new int[n];
        int[] dy = new int[n];
        int i = 0;
        while (i < n - 1) {
            int xdelta = x[i + 1] - x[i];
            int ydelta = y[i + 1] - y[i];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            length += segmentLength;
            segmentLengths[i] = segmentLength;
            dx[i] = xdelta;
            dy[i] = ydelta;
            ++i;
        }
        float[] values = new float[(int)length];
        double leftOver = 1.0;
        double distance = 0.0;
        double oldx = xbase;
        double oldy = ybase;
        int i2 = 0;
        while (i2 < n) {
            double len = segmentLengths[i2];
            if (len != 0.0) {
                double xinc = (double)dx[i2] / len;
                double yinc = (double)dy[i2] / len;
                double start = 1.0 - leftOver;
                double rx = (double)(xbase + x[i2]) + start * xinc;
                double ry = (double)(ybase + y[i2]) + start * yinc;
                double len2 = len - start;
                int n2 = (int)len2;
                int j = 0;
                while (j <= n2) {
                    int index = (int)distance + j;
                    if (index < values.length) {
                        if (this.rgb) {
                            int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                            values[index] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
                        } else {
                            values[index] = (float)ip.getInterpolatedValue(rx, ry);
                        }
                    }
                    rx += xinc;
                    ry += yinc;
                    ++j;
                }
                distance += len;
                leftOver = len2 - (double)n2;
            }
            ++i2;
        }
        return values;
    }

    private float[] getLine(ImageProcessor ip, double x1, double y1, double x2, double y2, float[] data) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (data == null) {
            data = new float[n];
        }
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double rx = x1;
        double ry = y1;
        int i = 0;
        while (i < n) {
            if (this.rgb) {
                int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                data[i] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
            } else {
                data[i] = (float)ip.getInterpolatedValue(rx, ry);
            }
            rx += xinc;
            ry += yinc;
            ++i;
        }
        return data;
    }

    void drawLine(double x1, double y1, double x2, double y2, ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Graphics g = ic.getGraphics();
        g.setColor(Roi.getColor());
        g.setXORMode(Color.black);
        g.drawLine(ic.screenX((int)(x1 + 0.5)), ic.screenY((int)(y1 + 0.5)), ic.screenX((int)(x2 + 0.5)), ic.screenY((int)(y2 + 0.5)));
    }
}

