/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class Binary
implements PlugInFilter {
    String arg;
    ImagePlus imp;
    static int iterations = 1;
    static boolean blackBackground = Prefs.blackBackground;
    static /* synthetic */ Class class$ij$plugin$filter$Binary;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Binary == null ? (class$ij$plugin$filter$Binary = Binary.class$("ij.plugin.filter.Binary")) : class$ij$plugin$filter$Binary);
        if (arg.equals("options")) {
            this.showDialog();
            return 4096;
        }
        if (arg.equals("outline") || arg.equals("skel")) {
            if (imp != null && (imp.getType() == 0 || imp.getType() == 3)) {
                ImageStatistics stats = imp.getStatistics();
                if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                    IJ.error("8-bit binary (black and white only) image required.");
                    return 4096;
                }
            }
            return IJ.setupDialog(imp, 67);
        }
        return IJ.setupDialog(imp, 83);
    }

    public void run(ImageProcessor ip) {
        if (this.arg.equals("erode")) {
            this.erode(ip);
        } else if (this.arg.equals("dilate")) {
            this.dilate(ip);
        } else if (this.arg.equals("open")) {
            this.open(ip);
        } else if (this.arg.equals("close")) {
            this.close(ip);
        } else if (this.arg.equals("outline")) {
            this.outline(ip);
        } else if (this.arg.equals("skel")) {
            this.skeletonize(ip);
        }
    }

    void erode(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            if (blackBackground) {
                ip.dilate();
            } else {
                ip.erode();
            }
            if (iterations > 1) {
                this.imp.updateAndDraw();
            }
            ++i;
        }
    }

    void dilate(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            if (blackBackground) {
                ip.erode();
            } else {
                ip.dilate();
            }
            if (iterations > 1) {
                this.imp.updateAndDraw();
            }
            ++i;
        }
    }

    void open(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            if (blackBackground) {
                ip.dilate();
            } else {
                ip.erode();
            }
            if (iterations > 1) {
                this.imp.updateAndDraw();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < iterations) {
            if (blackBackground) {
                ip.erode();
            } else {
                ip.dilate();
            }
            if (iterations > 1) {
                this.imp.updateAndDraw();
            }
            ++i2;
        }
    }

    void close(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            if (blackBackground) {
                ip.erode();
            } else {
                ip.dilate();
            }
            if (iterations > 1) {
                this.imp.updateAndDraw();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < iterations) {
            if (blackBackground) {
                ip.dilate();
            } else {
                ip.erode();
            }
            if (iterations > 1) {
                this.imp.updateAndDraw();
            }
            ++i2;
        }
    }

    void outline(ImageProcessor ip) {
        if (blackBackground) {
            ip.invert();
        }
        ((ByteProcessor)ip).outline();
        if (blackBackground) {
            ip.invert();
        }
    }

    void skeletonize(ImageProcessor ip) {
        if (blackBackground) {
            ip.invert();
        }
        ((ByteProcessor)ip).skeletonize();
        if (blackBackground) {
            ip.invert();
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Binary Options");
        gd.addNumericField("Iterations (1-25):", iterations, 0);
        gd.addCheckbox("Black Background", blackBackground);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        Prefs.blackBackground = blackBackground = gd.getNextBoolean();
        if (n > 25) {
            n = 25;
        }
        if (n < 1) {
            n = 1;
        }
        iterations = n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

