/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        String info = this.getImageInfo(this.imp, ip);
        if (info.indexOf("----") > 0) {
            this.showInfo(info, 400, 500);
        } else {
            this.showInfo(info, 300, 300);
        }
    }

    public String getImageInfo(ImagePlus imp, ImageProcessor ip) {
        ImageStack stack;
        String label;
        String infoProperty = null;
        if (imp.getStackSize() > 1 && (label = (stack = imp.getStack()).getSliceLabel(imp.getCurrentSlice())) != null && label.indexOf(10) > 0) {
            infoProperty = label;
        }
        if (infoProperty == null) {
            infoProperty = (String)imp.getProperty("Info");
        }
        String info = this.getInfo(imp, ip);
        if (infoProperty != null) {
            return infoProperty + "\n------------------------\n" + info;
        }
        return info;
    }

    String getInfo(ImagePlus imp, ImageProcessor ip) {
        Roi roi;
        int digits;
        String s = new String("\n");
        s = s + "Title: " + imp.getTitle() + "\n";
        Calibration cal = imp.getCalibration();
        int nSlices = imp.getStackSize();
        int n = digits = imp.getBitDepth() == 32 ? 4 : 0;
        if (cal.scaled()) {
            String unit = cal.getUnit();
            String units = cal.getUnits();
            s = s + "Width:  " + IJ.d2s((double)imp.getWidth() * cal.pixelWidth, 2) + " " + units + " (" + imp.getWidth() + ")\n";
            s = s + "Height:  " + IJ.d2s((double)imp.getHeight() * cal.pixelHeight, 2) + " " + units + " (" + imp.getHeight() + ")\n";
            if (nSlices > 1) {
                s = s + "Depth:  " + IJ.d2s((double)nSlices * cal.pixelDepth, 2) + " " + units + " (" + nSlices + ")\n";
            }
            if (nSlices > 1) {
                s = s + "Voxel size: " + IJ.d2s(cal.pixelWidth, 2) + "x" + IJ.d2s(cal.pixelHeight, 2) + "x" + IJ.d2s(cal.pixelDepth, 2) + "\n";
            }
            if (cal.pixelWidth == cal.pixelHeight) {
                s = s + "Resolution:  " + IJ.d2s(1.0 / cal.pixelWidth, 2) + " pixels per " + unit + "\n";
            } else {
                s = s + "X Resolution:  " + IJ.d2s(1.0 / cal.pixelWidth, 2) + " pixels per " + unit + "\n";
                s = s + "Y Resolution:  " + IJ.d2s(1.0 / cal.pixelHeight, 2) + " pixels per " + unit + "\n";
            }
        } else {
            s = s + "Width:  " + imp.getWidth() + " pixels\n";
            s = s + "Height:  " + imp.getHeight() + " pixels\n";
            if (nSlices > 1) {
                s = s + "Depth:  " + nSlices + " pixels\n";
            }
        }
        int type = imp.getType();
        switch (type) {
            case 0: {
                s = s + "Bits per pixel: 8 ";
                String lut = "LUT";
                lut = imp.getProcessor().isColorLut() ? "color " + lut : "grayscale " + lut;
                if (imp.isInvertedLut()) {
                    lut = "inverted " + lut;
                }
                s = s + "(" + lut + ")\n";
                break;
            }
            case 1: 
            case 2: {
                if (type == 1) {
                    ShortProcessor sp = (ShortProcessor)imp.getProcessor();
                    s = s + "Bits per pixel: 16 (unsigned short)\n";
                } else {
                    s = s + "Bits per pixel: 32 (float)\n";
                }
                s = s + "Display range: ";
                double min = ip.getMin();
                double max = ip.getMax();
                if (cal.calibrated()) {
                    min = cal.getCValue((int)min);
                    max = cal.getCValue((int)max);
                }
                s = s + IJ.d2s(min, digits) + " - " + IJ.d2s(max, digits) + "\n";
                break;
            }
            case 3: {
                s = s + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                s = s + "Bits per pixel: 32 (RGB)\n";
            }
        }
        double interval = cal.frameInterval;
        if (nSlices > 1 && interval != 0.0) {
            String label = interval > 0.0 ? "Frames: " : "Slices: ";
            s = s + label + nSlices + " (" + imp.getCurrentSlice() + ")\n";
            if (interval > 0.0) {
                if (interval < 1.0) {
                    double rate = 1.0 / interval;
                    String sRate = Math.abs(rate - (double)Math.round(rate)) < 1.0E-5 ? IJ.d2s(rate, 0) : IJ.d2s(rate, 5);
                    s = s + "Frame rate: " + sRate + " fps\n";
                } else {
                    s = s + "Frame interval: " + IJ.d2s(interval, 5) + " seconds\n";
                }
            }
        }
        if (ip.getMinThreshold() == -808080.0) {
            s = s + "No Threshold\n";
        } else {
            double lower = ip.getMinThreshold();
            double upper = ip.getMaxThreshold();
            int dp = digits;
            if (cal.calibrated()) {
                lower = cal.getCValue((int)lower);
                upper = cal.getCValue((int)upper);
                dp = cal.isSigned16Bit() ? 0 : 4;
            }
            s = s + "Threshold: " + IJ.d2s(lower, dp) + "-" + IJ.d2s(upper, dp) + "\n";
        }
        ImageCanvas ic = imp.getWindow().getCanvas();
        double mag = ic.getMagnification();
        if (mag != 1.0) {
            s = s + "Magnification: " + mag + "\n";
        }
        if (cal.calibrated()) {
            s = s + " \n";
            int curveFit = cal.getFunction();
            s = s + "Calibration Function: ";
            s = curveFit == 21 ? s + "Uncalibrated OD\n" : s + CurveFitter.fList[curveFit] + "\n";
            double[] c = cal.getCoefficients();
            if (c != null) {
                s = s + "  a: " + IJ.d2s(c[0], 6) + "\n";
                s = s + "  b: " + IJ.d2s(c[1], 6) + "\n";
                if (c.length >= 3) {
                    s = s + "  c: " + IJ.d2s(c[2], 6) + "\n";
                }
                if (c.length >= 4) {
                    s = s + "  c: " + IJ.d2s(c[3], 6) + "\n";
                }
                if (c.length >= 5) {
                    s = s + "  c: " + IJ.d2s(c[4], 6) + "\n";
                }
            }
            s = s + "  Unit: \"" + cal.getValueUnit() + "\"\n";
        } else {
            s = s + "Uncalibrated\n";
        }
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            if (fi.directory != null && fi.fileName != null) {
                s = s + "Path: " + fi.directory + fi.fileName + "\n";
            }
            if (fi.url != null && !fi.url.equals("")) {
                s = s + "URL: " + fi.url + "\n";
            }
        }
        if ((roi = imp.getRoi()) == null) {
            if (cal.calibrated()) {
                s = s + " \n";
            }
            s = s + "No Selection\n";
        } else {
            s = s + " \n";
            switch (roi.getType()) {
                case 0: {
                    s = s + "Rectangular Selection";
                    break;
                }
                case 1: {
                    s = s + "Oval Selection";
                    break;
                }
                case 2: {
                    s = s + "Polygon Selection";
                    break;
                }
                case 3: {
                    s = s + "Freehand Selection";
                    break;
                }
                case 4: {
                    s = s + "Traced Selection";
                    break;
                }
                case 5: {
                    s = s + "Line Selection";
                    break;
                }
                case 6: {
                    s = s + "Polyline Selection";
                    break;
                }
                case 7: {
                    s = s + "Freehand line Selection";
                }
            }
            String name = roi.getName();
            if (name != null) {
                s = s + " (\"" + name + "\")";
            }
            s = s + "\n";
            Rectangle r = roi.getBoundingRect();
            if (roi instanceof Line) {
                Line line = (Line)roi;
                s = s + "  X1: " + IJ.d2s((double)line.x1 * cal.pixelWidth) + "\n";
                s = s + "  Y1: " + IJ.d2s((double)this.yy(line.y1, imp) * cal.pixelHeight) + "\n";
                s = s + "  X2: " + IJ.d2s((double)line.x2 * cal.pixelWidth) + "\n";
                s = s + "  Y2: " + IJ.d2s((double)this.yy(line.y2, imp) * cal.pixelHeight) + "\n";
            } else if (cal.scaled()) {
                s = s + "  X: " + IJ.d2s((double)r.x * cal.pixelWidth) + " (" + r.x + ")\n";
                s = s + "  Y: " + IJ.d2s((double)this.yy(r.y, imp) * cal.pixelHeight) + " (" + r.y + ")\n";
                s = s + "  Width: " + IJ.d2s((double)r.width * cal.pixelWidth) + " (" + r.width + ")\n";
                s = s + "  Height: " + IJ.d2s((double)r.height * cal.pixelHeight) + " (" + r.height + ")\n";
            } else {
                s = s + "  X: " + r.x + "\n";
                s = s + "  Y: " + this.yy(r.y, imp) + "\n";
                s = s + "  Width: " + r.width + "\n";
                s = s + "  Height: " + r.height + "\n";
            }
        }
        return s;
    }

    int yy(int y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    void showInfo(String info, int width, int height) {
        new TextWindow("Info for " + this.imp.getTitle(), info, width, height);
    }
}

