/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;

public class LutApplier
implements PlugInFilter {
    ImagePlus imp;
    int min;
    int max;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 3;
    }

    public void run(ImageProcessor ip) {
        this.apply(this.imp, ip);
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        this.min = (int)ip.getMin();
        this.max = (int)ip.getMax();
        if (this.min == 0 && this.max == 255) {
            IJ.showMessage("Apply LUT", "The display range must first be updated \nusing Image->Adjust->Brightness/Contrast.");
            return;
        }
        ip.resetMinAndMax();
        if (imp.getType() == 4) {
            if (imp.getStackSize() > 1) {
                this.applyRGBStack(imp);
            } else {
                ip.snapshot();
            }
            return;
        }
        int[] table = new int[256];
        int i = 0;
        while (i < 256) {
            table[i] = i <= this.min ? 0 : (i >= this.max ? 255 : (int)((double)(i - this.min) / (double)(this.max - this.min) * 255.0));
            ++i;
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            int flags = IJ.setupDialog(imp, 0);
            if (flags == 4096) {
                ip.setMinAndMax(this.min, this.max);
                return;
            }
            if (flags == 32) {
                new StackProcessor(stack, ip).applyTable(table);
                Undo.reset();
            } else {
                ip.applyTable(table);
            }
        } else {
            ip.applyTable(table);
        }
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        int i = 1;
        while (i <= n) {
            if (i != current) {
                imp.setSlice(i);
                ImageProcessor ip = imp.getProcessor();
                ip.setMinAndMax(this.min, this.max);
                IJ.showProgress((double)i / (double)n);
            }
            ++i;
        }
        imp.setSlice(current);
    }
}

