/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.StringTokenizer;

public class Recorder
extends PlugInFrame
implements PlugIn,
ActionListener,
ItemListener {
    public static boolean record;
    private Button makeMacro;
    private Button makePlugin;
    private Checkbox recordCB;
    private String fitTypeStr = CurveFitter.fitList[0];
    private static TextArea textArea;
    private static Frame instance;
    private static String commandName;
    private static String commandOptions;
    static /* synthetic */ Class class$ij$plugin$frame$Recorder;

    public Recorder() {
        super("Recorder");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        Panel panel = new Panel();
        record = true;
        this.recordCB = new Checkbox("Record", record);
        this.recordCB.addItemListener(this);
        panel.add(this.recordCB);
        this.makeMacro = new Button("Create Macro");
        this.makeMacro.addActionListener(this);
        panel.add(this.makeMacro);
        this.makePlugin = new Button("Create Plugin");
        this.makePlugin.addActionListener(this);
        panel.add(this.makePlugin);
        this.add("North", panel);
        textArea = new TextArea("", 15, 60, 1);
        textArea.setFont(new Font("Monospaced", 0, 12));
        this.add("Center", textArea);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(class$ij$plugin$frame$Recorder == null ? (class$ij$plugin$frame$Recorder = Recorder.class$("ij.plugin.frame.Recorder")) : class$ij$plugin$frame$Recorder);
    }

    public static void record(String method) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "();\n");
    }

    public static void setCommand(String command) {
        if (textArea == null || Thread.currentThread().getName().startsWith("Run$_")) {
            return;
        }
        commandName = command;
        commandOptions = null;
    }

    static String fixPath(String path) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            sb.append(c);
            if (c == '\\') {
                sb.append("\\");
            }
            ++i;
        }
        return new String(sb);
    }

    public static void record(String method, String arg) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(\"" + arg + "\");\n");
    }

    public static void record(String method, int a1) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ");\n");
    }

    public static void record(String method, int a1, int a2) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ", " + a2 + ");\n");
    }

    public static void record(String method, double a1, double a2) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ", " + a2 + ");\n");
    }

    public static void record(String method, int a1, int a2, int a3) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ");\n");
    }

    public static void record(String method, String args, int a1, int a2) {
        if (textArea == null) {
            return;
        }
        method = "//" + method;
        textArea.append(method + "(\"" + args + "\", " + a1 + ", " + a2 + ");\n");
    }

    public static void record(String method, int a1, int a2, int a3, int a4) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ");\n");
    }

    public static void record(String method, String path, String args, int a1, int a2, int a3, int a4, int a5) {
        if (textArea == null) {
            return;
        }
        path = Recorder.fixPath(path);
        method = "//" + method;
        textArea.append(method + "(\"" + path + "\", " + "\"" + args + "\", " + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ", " + a5 + ");\n");
    }

    public static void recordOption(String key, String value) {
        key = Recorder.trimKey(key);
        value = Recorder.addQuotes(value);
        commandOptions = commandOptions == null ? key + "=" + value : commandOptions + " " + key + "=" + value;
    }

    public static void recordPath(String key, String path) {
        if (key == null) {
            return;
        }
        key = Recorder.trimKey(key);
        path = Recorder.fixPath(path);
        path = Recorder.addQuotes(path);
        commandOptions = commandOptions == null ? key + "=" + path : commandOptions + " " + key + "=" + path;
    }

    public static void recordOption(String key) {
        if (commandOptions == null && key.equals(" ")) {
            commandOptions = " ";
        } else {
            key = Recorder.trimKey(key);
            commandOptions = commandOptions == null ? key : commandOptions + " " + key;
        }
    }

    static String trimKey(String key) {
        int index = key.indexOf(" ");
        if (index > -1) {
            key = key.substring(0, index);
        }
        if ((index = key.indexOf(":")) > -1) {
            key = key.substring(0, index);
        }
        key = key.toLowerCase(Locale.US);
        return key;
    }

    public static void saveCommand() {
        if (commandName != null) {
            if (commandOptions != null) {
                textArea.append("run(\"" + commandName + "\", \"" + commandOptions + "\");\n");
            } else {
                textArea.append("run(\"" + commandName + "\");\n");
            }
        }
        commandName = null;
        commandOptions = null;
    }

    static String addQuotes(String value) {
        int index = value.indexOf(32);
        if (index > -1) {
            value = "'" + value + "'";
        }
        return value;
    }

    void createPlugin() {
        String text = textArea.getText();
        if (text == null || text.equals("")) {
            IJ.runPlugIn("ij.plugin.NewPlugin", " ");
            return;
        }
        StringTokenizer st = new StringTokenizer(text, "\n");
        int n = st.countTokens();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            String line = st.nextToken();
            if (line != null && line.length() > 3) {
                sb.append("\t\tIJ.");
                sb.append(line);
                sb.append('\n');
            }
            ++i;
        }
        IJ.runPlugIn("ij.plugin.NewPlugin", new String(sb));
    }

    void createMacro() {
        String text = textArea.getText();
        if (text == null || text.equals("")) {
            return;
        }
        Editor ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (ed == null) {
            return;
        }
        ed.create("macro.txt", text);
    }

    public void itemStateChanged(ItemEvent e) {
        record = this.recordCB.getState();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.makeMacro) {
            this.createMacro();
        } else if (e.getSource() == this.makePlugin) {
            this.createPlugin();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void close() {
        super.close();
        record = false;
        textArea = null;
        commandName = null;
        instance = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

