/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.MessageDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener {
    Panel panel;
    static Frame instance;
    List list;
    Hashtable rois = new Hashtable();

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        this.setLayout(new FlowLayout(1, 5, 5));
        int rows = 18;
        this.list = new List(rows, true);
        this.list.add("012345678901234567");
        this.list.addItemListener(this);
        this.add(this.list);
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(11, 1, 5, 0));
        this.addButton("Add");
        this.addButton("Add & Draw");
        this.addButton("Rename");
        this.addButton("Delete");
        this.addButton("Open");
        this.addButton("Open All");
        this.addButton("Save");
        this.addButton("Select All");
        this.addButton("Measure");
        this.addButton("Draw");
        this.addButton("Fill");
        this.add(this.panel);
        this.pack();
        this.list.remove(0);
        GUI.center(this);
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        this.panel.add(b);
    }

    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        if (command.equals("Add")) {
            this.add();
        }
        if (command.equals("Add & Draw")) {
            this.addAndDraw();
        } else if (command.equals("Rename")) {
            this.rename();
        } else if (command.equals("Delete")) {
            this.delete();
        } else if (command.equals("Open")) {
            this.open();
        } else if (command.equals("Open All")) {
            this.openAll();
        } else if (command.equals("Save")) {
            this.save();
        } else if (command.equals("Select All")) {
            this.selectAll();
        } else if (command.equals("Measure")) {
            this.measure();
        } else if (command.equals("Draw")) {
            this.draw();
        } else if (command.equals("Fill")) {
            this.fill();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && WindowManager.getCurrentImage() != null) {
            int index = 0;
            try {
                index = Integer.parseInt(e.getItem().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (index < 0) {
                index = 0;
            }
            this.restore(index);
        }
    }

    boolean add() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        String type = null;
        switch (roi.getType()) {
            case 0: {
                type = "Rectangle";
                break;
            }
            case 1: {
                type = "Oval";
                break;
            }
            case 2: {
                type = "Polygon";
                break;
            }
            case 3: {
                type = "Freehand";
                break;
            }
            case 4: {
                type = "Traced";
                break;
            }
            case 5: {
                type = "Line";
                break;
            }
            case 6: {
                type = "Polyline";
                break;
            }
            case 7: {
                type = "Freeline";
            }
        }
        if (type == null) {
            return false;
        }
        Rectangle r = roi.getBoundingRect();
        String name = roi.getName();
        String label = name != null ? this.getUniqueName(name) : this.getUniqueLabel(type);
        this.list.add(label);
        if (name == null) {
            roi.setName(label);
        }
        this.rois.put(label, roi.clone());
        return true;
    }

    String getUniqueLabel(String label) {
        String label2 = label + "001";
        int n = 2;
        Roi roi2 = (Roi)this.rois.get(label2);
        while (roi2 != null) {
            roi2 = (Roi)this.rois.get(label2);
            if (roi2 != null) {
                String ext = "" + n;
                while (ext.length() < 3) {
                    ext = "0" + ext;
                }
                label2 = label2.substring(0, label2.length() - 3) + ext;
            }
            ++n;
            roi2 = (Roi)this.rois.get(label2);
        }
        return label2;
    }

    void addAndDraw() {
        if (this.add()) {
            this.list.select(this.list.getItemCount() - 1);
            this.draw();
        }
    }

    boolean delete() {
        int count = this.list.getItemCount();
        if (count == 0) {
            return this.error("The RSelection list is empty.");
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error("At least one Selection in the list must be selected.");
        }
        int i = count - 1;
        while (i >= 0) {
            boolean delete = false;
            int j = 0;
            while (j < index.length) {
                if (index[j] == i) {
                    delete = true;
                }
                ++j;
            }
            if (delete) {
                this.rois.remove(this.list.getItem(i));
                this.list.remove(i);
            }
            --i;
        }
        return true;
    }

    boolean rename() {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = this.list.getItem(index);
        GenericDialog gd = new GenericDialog("ROI Manager");
        gd.addStringField("Rename As:", name, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String name2 = gd.getNextString();
        name2 = this.getUniqueName(name2);
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        roi.setName(name2);
        this.rois.put(name2, roi);
        this.list.replaceItem(name2, index);
        this.list.select(index);
        return true;
    }

    boolean restore(int index) {
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        ImagePlus imp = this.getImage();
        if (imp == null || roi == null) {
            return false;
        }
        Rectangle r = roi.getBoundingRect();
        if (r.x + r.width > imp.getWidth() || r.y + r.height > imp.getHeight()) {
            return this.error("This selection does not fit the current image.");
        }
        imp.setRoi(roi);
        return true;
    }

    void open() {
        Macro.setOptions(null);
        OpenDialog od = new OpenDialog("Open Selection...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        Opener o = new Opener();
        String path = directory + name;
        Roi roi = o.openRoi(path);
        if (roi != null) {
            if (name.endsWith(".roi")) {
                name = name.substring(0, name.length() - 4);
            }
            name = this.getUniqueName(name);
            this.list.add(name);
            this.rois.put(name, roi);
        }
    }

    String getUniqueName(String name) {
        String name2 = name;
        int n = 1;
        Roi roi2 = (Roi)this.rois.get(name2);
        while (roi2 != null) {
            roi2 = (Roi)this.rois.get(name2);
            if (roi2 != null) {
                name2 = name + "-" + n;
            }
            ++n;
            roi2 = (Roi)this.rois.get(name2);
        }
        return name2;
    }

    void openAll() {
        Macro.setOptions(null);
        Macro.setOptions(null);
        OpenDialog od = new OpenDialog("Select a file in the folder...", "");
        if (od.getFileName() == null) {
            return;
        }
        String dir = od.getDirectory();
        String[] files = new File(dir).list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            Roi roi;
            File f = new File(dir + files[i]);
            if (!f.isDirectory() && files[i].endsWith(".roi") && (roi = new Opener().openRoi(dir + files[i])) != null) {
                String name = files[i];
                if (name.endsWith(".roi")) {
                    name = name.substring(0, name.length() - 4);
                }
                name = this.getUniqueName(name);
                this.list.add(name);
                this.rois.put(name, roi);
            }
            ++i;
        }
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error("At least one item in the list must be selected.");
        }
        String name = this.list.getItem(index[0]);
        Macro.setOptions(null);
        SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
        String name2 = sd.getFileName();
        if (name == null) {
            return false;
        }
        if (index.length == 1) {
            Roi roi = (Roi)this.rois.get(name);
            this.rois.remove(name);
            if (name2.endsWith(".roi")) {
                name2 = name2.substring(0, name2.length() - 4);
            }
            this.rois.put(name2, roi);
            this.list.replaceItem(name2, index[0]);
            this.list.select(index[0]);
            index = this.list.getSelectedIndexes();
        }
        String dir = sd.getDirectory();
        int i = 0;
        while (i < index.length) {
            if (!this.restore(index[i])) break;
            name = this.list.getItem(index[i]);
            if (!name.endsWith(".roi")) {
                name = name + ".roi";
            }
            IJ.run("Selection...", "path='" + dir + name + "'");
            ++i;
        }
        return true;
    }

    void selectAll() {
        boolean allSelected = true;
        int count = this.list.getItemCount();
        int i = 0;
        while (i < count) {
            if (!this.list.isIndexSelected(i)) {
                allSelected = false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            if (allSelected) {
                this.list.deselect(i2);
            } else {
                this.list.select(i2);
            }
            ++i2;
        }
    }

    boolean measure() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error("At least one item must be selected from the list.");
        }
        int setup = IJ.setupDialog(imp, 0);
        if (setup == 4096) {
            return false;
        }
        int nSlices = setup == 32 ? imp.getStackSize() : 1;
        int currentSlice = imp.getCurrentSlice();
        int slice = 1;
        while (slice <= nSlices) {
            if (nSlices > 1) {
                imp.setSlice(slice);
            }
            int i = 0;
            while (i < index.length) {
                if (!this.restore(index[i])) break;
                IJ.run("Measure");
                ++i;
            }
            ++slice;
        }
        imp.setSlice(currentSlice);
        if (index.length > 1) {
            IJ.run("Select None");
        }
        return true;
    }

    boolean fill() {
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error("At least one item must be selected from the list.");
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        int i = 0;
        while (i < index.length) {
            if (!this.restore(index[i])) break;
            IJ.run("Fill");
            IJ.run("Select None");
            ++i;
        }
        Undo.setup(5, imp);
        return true;
    }

    boolean draw() {
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error("At least one item must be selected from the list.");
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        int i = 0;
        while (i < index.length) {
            if (!this.restore(index[i])) break;
            IJ.run("Draw");
            IJ.run("Select None");
            ++i;
        }
        Undo.setup(5, imp);
        return true;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error("There are no images open.");
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        return false;
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }
}

