/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class PolygonFiller {
    int BLACK = -16777216;
    int WHITE = -1;
    int edges;
    int activeEdges;
    int[] x;
    int[] y;
    int n;
    double[] ex;
    int[] ey1;
    int[] ey2;
    double[] eslope;
    int[] sedge;
    int[] aedge;

    public PolygonFiller() {
    }

    public PolygonFiller(int[] x, int[] y, int n) {
        this.setPolygon(x, y, n);
    }

    public void setPolygon(int[] x, int[] y, int n) {
        this.x = x;
        this.y = y;
        this.n = n;
    }

    void allocateArrays(int n) {
        if (this.ex == null || n > this.ex.length) {
            this.ex = new double[n];
            this.ey1 = new int[n];
            this.ey2 = new int[n];
            this.sedge = new int[n];
            this.aedge = new int[n];
            this.eslope = new double[n];
        }
    }

    void buildEdgeTable(int[] x, int[] y, int n) {
        this.edges = 0;
        int i = 0;
        while (i < n) {
            int iplus1 = i == n - 1 ? 0 : i + 1;
            int y1 = y[i];
            int y2 = y[iplus1];
            int x1 = x[i];
            int x2 = x[iplus1];
            if (y1 != y2) {
                if (y1 > y2) {
                    int tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                    tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                this.ex[this.edges] = x1;
                this.ey1[this.edges] = y1;
                this.ey2[this.edges] = y2;
                this.eslope[this.edges] = (double)(x2 - x1) / (double)(y2 - y1);
                ++this.edges;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.edges) {
            this.sedge[i2] = i2;
            ++i2;
        }
        this.activeEdges = 0;
    }

    void addToSortedTable(int edge) {
        int index = 0;
        while (index < this.edges && this.ey1[this.edges] > this.ey1[this.sedge[index]]) {
            ++index;
        }
        int i = this.edges - 1;
        while (i >= index) {
            this.sedge[i + 1] = this.sedge[i];
            --i;
        }
        this.sedge[index] = this.edges;
    }

    public void fill(ImageProcessor ip, Rectangle r) {
        ip.fill(this.getMask(r.width, r.height));
    }

    public int[] getMask(int width, int height) {
        this.allocateArrays(this.n);
        this.buildEdgeTable(this.x, this.y, this.n);
        int size = width * height;
        int[] mask = new int[size];
        int i = 0;
        while (i < size) {
            mask[i] = this.WHITE;
            ++i;
        }
        int y = 0;
        while (y < height) {
            this.removeInactiveEdges(y);
            this.activateEdges(y);
            int offset = y * width;
            int i2 = 0;
            while (i2 < this.activeEdges) {
                int x2;
                int x1 = (int)Math.round(this.ex[this.aedge[i2]]);
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x1 > width) {
                    x1 = width;
                }
                if ((x2 = (int)Math.round(this.ex[this.aedge[i2 + 1]])) < 0) {
                    x2 = 0;
                }
                if (x2 > width) {
                    x2 = width;
                }
                int x = x1;
                while (x < x2) {
                    mask[offset + x] = this.BLACK;
                    ++x;
                }
                i2 += 2;
            }
            this.updateXCoordinates(y);
            ++y;
        }
        return mask;
    }

    void updateXCoordinates(int y) {
        double x1 = -1.7976931348623157E308;
        boolean sorted = true;
        int i = 0;
        while (i < this.activeEdges) {
            double x2;
            int index = this.aedge[i];
            this.ex[index] = x2 = this.ex[index] + this.eslope[index];
            if (x2 < x1) {
                sorted = false;
            }
            x1 = x2;
            ++i;
        }
        if (!sorted) {
            this.sortActiveEdges();
        }
    }

    void sortActiveEdges() {
        int i = 0;
        while (i < this.activeEdges) {
            int min = i;
            int j = i;
            while (j < this.activeEdges) {
                if (this.ex[this.aedge[j]] < this.ex[this.aedge[min]]) {
                    min = j;
                }
                ++j;
            }
            int tmp = this.aedge[min];
            this.aedge[min] = this.aedge[i];
            this.aedge[i] = tmp;
            ++i;
        }
    }

    void removeInactiveEdges(int y) {
        int i = 0;
        while (i < this.activeEdges) {
            int index = this.aedge[i];
            if (y < this.ey1[index] || y >= this.ey2[index]) {
                int j = i;
                while (j < this.activeEdges - 1) {
                    this.aedge[j] = this.aedge[j + 1];
                    ++j;
                }
                --this.activeEdges;
                continue;
            }
            ++i;
        }
    }

    void activateEdges(int y) {
        int i = 0;
        while (i < this.edges) {
            int edge = this.sedge[i];
            if (y == this.ey1[edge]) {
                int index = 0;
                while (index < this.activeEdges && this.ex[edge] > this.ex[this.aedge[index]]) {
                    ++index;
                }
                int j = this.activeEdges - 1;
                while (j >= index) {
                    this.aedge[j + 1] = this.aedge[j];
                    --j;
                }
                this.aedge[index] = edge;
                ++this.activeEdges;
            }
            ++i;
        }
    }

    void printEdges() {
        int i = 0;
        while (i < this.edges) {
            int index = this.sedge[i];
            IJ.log(i + "\t" + this.ex[index] + "  " + this.ey1[index] + "  " + this.ey2[index] + "  " + IJ.d2s(this.eslope[index], 2));
            ++i;
        }
    }

    void printActiveEdges() {
        int i = 0;
        while (i < this.activeEdges) {
            int index = this.aedge[i];
            IJ.log(i + "\t" + this.ex[index] + "  " + this.ey1[index] + "  " + this.ey2[index]);
            ++i;
        }
    }

    void quickSort(int[] a) {
        this.quickSort(a, 0, a.length - 1);
    }

    void quickSort(int[] a, int from, int to) {
        int i = from;
        int j = to;
        int center = a[(from + to) / 2];
        while (true) {
            if (i < to && this.ey1[center] > this.ey1[a[i]]) {
                --j;
                continue;
            }
            while (j > from && this.ey1[center] < this.ey1[a[j]]) {
                --j;
            }
            if (i < j) {
                int temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            this.quickSort(a, from, j);
        }
        if (i < to) {
            this.quickSort(a, i, to);
        }
    }
}

