/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.control;

import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mitre.mrald.util.MraldOutFile;

public class UserThread {
    protected String user;
    protected long started;
    protected Statement stmt;
    protected String query;
    protected Thread thread;

    public UserThread() {
    }

    public UserThread(String passed_user, String passed_query, long passed_timestamp, Statement passed_stmt, Thread passed_thread) {
        this.user = passed_user;
        this.query = passed_query;
        this.started = passed_timestamp;
        this.stmt = passed_stmt;
        this.thread = passed_thread;
    }

    public String getUser() {
        return this.user;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getStarted() {
        return this.started;
    }

    public Statement getStmt() {
        return this.stmt;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("User: ");
        ret.append(this.user);
        ret.append("\nStarted: ");
        ret.append(this.started);
        ret.append("\nQuery: ");
        ret.append(this.query);
        ret.append("\nstmt: ");
        ret.append(this.stmt);
        return ret.toString();
    }

    public String toOneLineString() {
        StringBuffer ret = new StringBuffer();
        ret.append("User: ");
        ret.append(this.user);
        ret.append("; Started: ");
        ret.append(this.started);
        ret.append("; Query: ");
        ret.append(this.query);
        ret.append("; stmt: ");
        ret.append(this.stmt);
        return ret.toString();
    }

    public String toHtmlTableRow() {
        StringBuffer ret = new StringBuffer();
        ret.append("<td>");
        ret.append(this.user);
        ret.append("</td><td>");
        SimpleDateFormat dFormat = new SimpleDateFormat("d MMM yy, HH:mm:ss");
        ret.append(dFormat.format(new Date(this.started)));
        ret.append("</td><td>");
        DecimalFormat format = new DecimalFormat("0.0");
        ret.append(format.format((double)((System.currentTimeMillis() - this.started) / 1000L) / 60.0));
        ret.append("</td><td>");
        ret.append(this.query);
        ret.append("</td><td>");
        ret.append("<a href=\"KillThread.jsp?start=");
        ret.append(this.started);
        ret.append("\">Kill</a>");
        ret.append("</td>");
        return ret.toString();
    }

    public void kill() {
        try {
            if (this.thread.isAlive()) {
                this.stmt.close();
                MraldOutFile.logToFile("Query killed\n" + this.toString());
            } else {
                MraldOutFile.logToFile("User tried to kill query, but it was already done\n" + this.toString());
            }
        }
        catch (SQLException e) {
            MraldOutFile.logToFile("Tried to kill a java.sql.Statment that was already dead (or some other problem).\n" + e.toString());
        }
    }
}

