/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.action.RepaintAction;
import edu.berkeley.guir.prefuse.action.assignment.ColorFunction;
import edu.berkeley.guir.prefuse.action.filter.GraphFilter;
import edu.berkeley.guir.prefuse.activity.ActionList;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.render.DefaultEdgeRenderer;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import edu.berkeley.guir.prefuse.render.TextItemRenderer;
import edu.berkeley.guir.prefusex.controls.DragControl;
import edu.berkeley.guir.prefusex.controls.NeighborHighlightControl;
import edu.berkeley.guir.prefusex.controls.PanControl;
import edu.berkeley.guir.prefusex.controls.ZoomControl;
import edu.berkeley.guir.prefusex.force.DragForce;
import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import edu.berkeley.guir.prefusex.force.NBodyForce;
import edu.berkeley.guir.prefusex.force.SpringForce;
import edu.berkeley.guir.prefusex.layout.ForceDirectedLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.JApplet;
import org.mitre.mrald.graphics.DBGraphReader;

public class ForceDBApplet
extends JApplet {
    private ActionList forces;

    public void init() {
        String textField = this.getParameter("label");
        Graph g = null;
        try {
            String inputFile = "";
            g = new DBGraphReader().loadGraph(inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ItemRegistry registry = new ItemRegistry(g);
        Display display = new Display(registry);
        display.setSize(500, 500);
        display.pan(250.0, 250.0);
        TextItemRenderer nodeRenderer = new TextItemRenderer();
        nodeRenderer.setRenderType(2);
        nodeRenderer.setRoundedCorner(8, 8);
        nodeRenderer.setTextAttributeName(textField);
        DefaultEdgeRenderer edgeRenderer = new DefaultEdgeRenderer();
        registry.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, null));
        ActionList filter = new ActionList(registry);
        filter.add((Action)new GraphFilter());
        ForceSimulator fsim = new ForceSimulator();
        fsim.addForce((Force)new NBodyForce(-0.4f, -1.0f, 0.9f));
        fsim.addForce((Force)new SpringForce(2.0E-5f, 75.0f));
        fsim.addForce((Force)new DragForce(-0.01f));
        this.forces = new ActionList(registry, -1L, 20L);
        this.forces.add((Action)new ForceDirectedLayout(fsim, false, false));
        this.forces.add((Action)new DemoColorFunction());
        this.forces.add((Action)new RepaintAction());
        display.addControlListener((ControlListener)new NeighborHighlightControl());
        display.addControlListener((ControlListener)new DragControl(false, true));
        display.addControlListener((ControlListener)new PanControl(false));
        display.addControlListener((ControlListener)new ZoomControl(false));
        this.getContentPane().add((Component)display);
        filter.runNow();
    }

    public void start() {
        this.forces.runNow();
    }

    public void stop() {
        this.forces.cancel();
    }

    public class DemoColorFunction
    extends ColorFunction {
        private Color pastelRed = new Color(255, 125, 125);
        private Color pastelOrange = new Color(255, 200, 125);
        private Color lightGray = new Color(220, 220, 255);

        public Paint getColor(VisualItem item) {
            if (item instanceof EdgeItem) {
                if (item.isHighlighted()) {
                    return this.pastelOrange;
                }
                return Color.LIGHT_GRAY;
            }
            return Color.BLACK;
        }

        public Paint getFillColor(VisualItem item) {
            if (item.isHighlighted()) {
                return this.pastelOrange;
            }
            if (item instanceof NodeItem) {
                if (item.isFixed()) {
                    return this.pastelRed;
                }
                return this.lightGray;
            }
            return Color.BLACK;
        }
    }
}

