/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MiscUtils;

public class MraldOutFile {
    static String fileUrl = Config.getProperty("LOGFILE");

    public static void appendToFile(String fileName, String text) {
        PrintWriter out = null;
        String fileUrl = Config.getProperty("LOGPATH") + fileName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileUrl, true)));
            out.print(Config.NEWLINE + text);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println(MiscUtils.formatThrowable(e));
            if (out != null) {
                out.close();
            }
            MraldOutFile.createFile(fileName, text);
        }
    }

    public static synchronized void createFile(String fileName, String text) {
        String fileUrl = Config.getProperty("LOGPATH") + fileName;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(fileUrl, false)));
            writer.print(text);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            String mailText = "Couldn't create " + fileUrl + "\n\nThe stack trace was printed to System.out in the MRALD install at " + Config.getProperty("BaseUrl") + ".  The message that was to be conveyed was:\n\n" + text;
            System.out.println(mailText);
            e.printStackTrace(System.out);
            try {
                Mailer.send(Config.getProperty("MAILTO"), "MraldOutFile", Config.getProperty("SMTPHOST"), mailText, "Error in MraldOutFile.createFile()");
            }
            catch (Exception e2) {
                e2.printStackTrace(System.out);
            }
        }
    }

    public static void logToFile(Throwable t) {
        MraldOutFile.logToFile(MiscUtils.formatThrowable(t));
    }

    public static void logToFile(String fileName, StackTraceElement[] ste) {
        String time = Calendar.getInstance().getTime().toString();
        PrintWriter out = null;
        String fileUrl = Config.getProperty("LOGPATH") + fileName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileUrl, true)));
            out.print(Config.NEWLINE + time);
            for (int i = 0; i < ste.length; ++i) {
                out.print(Config.NEWLINE + ste[i].toString());
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            try {
                out.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < ste.length; ++i) {
                ret.append(Config.NEWLINE + ste[i].toString());
            }
            String text = ret.toString();
            MraldOutFile.createFile(fileName, time + Config.NEWLINE + text);
        }
    }

    public static void appendToFile(String text) {
        MraldOutFile.appendToFile(Config.getProperty("LOGFILE"), text);
    }

    public static void logToFile(String text) {
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), text);
    }

    public static void logToFile(StackTraceElement[] ste) {
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), ste);
    }

    public static void logToFile(String fileName, String text) {
        String time = Calendar.getInstance().getTime().toString();
        PrintWriter out = null;
        String fileUrl = Config.getProperty("LOGPATH") + fileName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileUrl, true)));
            out.print(Config.NEWLINE + time);
            out.print(Config.NEWLINE + text);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            try {
                out.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            MraldOutFile.createFile(fileName, time + Config.NEWLINE + text);
        }
    }
}

