/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class PrintUtilities
implements Printable {
    private Component[] componentsToBePrinted;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    public static void printComponent(Component[] c) {
        new PrintUtilities(c).print();
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentsToBePrinted = new Component[]{componentToBePrinted};
    }

    public PrintUtilities(Component[] componentsToBePrinted) {
        this.componentsToBePrinted = componentsToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public void addComponent(Component componentToBePrinted) {
        int size = this.componentsToBePrinted.length;
        Component[] newComponents = new Component[size + 1];
        for (int i = 0; i < size; ++i) {
            newComponents[i] = this.componentsToBePrinted[i];
        }
        newComponents[size] = componentToBePrinted;
        this.componentsToBePrinted = newComponents;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > this.componentsToBePrinted.length - 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double scaleWidth = pageFormat.getImageableWidth() / (double)this.componentsToBePrinted[pageIndex].getWidth();
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2d.scale(scaleWidth, scaleWidth);
        this.componentsToBePrinted[pageIndex].print(g2d);
        return 0;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex, boolean printAll) {
        if (pageIndex > 0) {
            return 1;
        }
        if (!printAll) {
            return this.print(g, pageFormat, pageIndex);
        }
        int size = this.componentsToBePrinted.length;
        for (int i = 0; i < size; ++i) {
            Graphics2D g2d = (Graphics2D)g;
            double scaleWidth = pageFormat.getImageableWidth() / (double)this.componentsToBePrinted[i].getWidth();
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.scale(scaleWidth, scaleWidth);
            this.componentsToBePrinted[i].print(g2d);
        }
        return 0;
    }
}

