/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.activity.SlowInSlowOutPacer;
import edu.berkeley.guir.prefuse.event.ControlEventMulticaster;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.util.ColorLib;
import edu.berkeley.guir.prefuse.util.FontLib;
import edu.berkeley.guir.prefuse.util.display.Clip;
import edu.berkeley.guir.prefuse.util.display.ExportDisplayAction;
import edu.berkeley.guir.prefuse.util.display.ToolTipManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class Display
extends JComponent {
    protected ItemRegistry m_registry;
    protected ControlListener m_listener;
    protected BufferedImage m_offscreen;
    protected Clip m_clip = new Clip();
    protected boolean m_showDebug = false;
    protected boolean m_repaint = false;
    protected boolean m_highQuality = false;
    protected AffineTransform m_transform = new AffineTransform();
    protected AffineTransform m_itransform = new AffineTransform();
    protected TransformActivity m_transact = new TransformActivity();
    protected Point2D m_tmpPoint = new Point2D.Double();
    protected double frameRate;
    protected int nframes = 0;
    private int sampleInterval = 10;
    private long mark = -1L;
    private JTextComponent m_editor;
    private boolean m_editing;
    private VisualItem m_editItem;
    private String m_editAttribute;
    private ToolTipManager m_ttipManager;

    public Display() {
        this(null);
    }

    public Display(ItemRegistry itemRegistry) {
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
        this.m_editing = false;
        this.m_editor = new JTextField();
        this.m_editor.setBorder(null);
        this.m_editor.setVisible(false);
        this.add(this.m_editor);
        InputEventCapturer inputEventCapturer = new InputEventCapturer();
        this.addMouseListener(inputEventCapturer);
        this.addMouseMotionListener(inputEventCapturer);
        this.addMouseWheelListener(inputEventCapturer);
        this.addKeyListener(inputEventCapturer);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.m_showDebug = !Display.this.m_showDebug;
            }
        }, "debug info", KeyStroke.getKeyStroke("ctrl D"), 0);
        try {
            this.registerKeyboardAction(new ExportDisplayAction(this), "export display", KeyStroke.getKeyStroke("ctrl E"), 0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setItemRegistry(itemRegistry);
        this.setSize(400, 400);
    }

    public void setDebug(boolean bl) {
        this.m_showDebug = bl;
    }

    public boolean getDebug() {
        return this.m_showDebug;
    }

    public void setUseCustomTooltips(boolean bl) {
        if (bl && this.m_ttipManager == null) {
            this.m_ttipManager = new ToolTipManager(this);
            String string = super.getToolTipText();
            super.setToolTipText(null);
            this.m_ttipManager.setToolTipText(string);
            this.addMouseMotionListener(this.m_ttipManager);
        } else if (!bl && this.m_ttipManager != null) {
            this.removeMouseMotionListener(this.m_ttipManager);
            String string = this.m_ttipManager.getToolTipText();
            this.m_ttipManager.setToolTipText(null);
            super.setToolTipText(string);
            this.m_ttipManager = null;
        }
    }

    public ToolTipManager getToolTipManager() {
        return this.m_ttipManager;
    }

    public void setToolTipText(String string) {
        if (this.m_ttipManager != null) {
            this.m_ttipManager.setToolTipText(string);
        } else {
            super.setToolTipText(string);
        }
    }

    public void setSize(int n, int n2) {
        this.m_offscreen = null;
        this.setPreferredSize(new Dimension(n, n2));
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.m_offscreen = null;
        this.setPreferredSize(dimension);
        super.setSize(dimension);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.m_offscreen = null;
        super.reshape(n, n2, n3, n4);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.m_editor.setFont(font);
    }

    public void setHighQuality(boolean bl) {
        this.m_highQuality = bl;
    }

    public boolean isHighQuality() {
        return this.m_highQuality;
    }

    public ItemRegistry getRegistry() {
        return this.m_registry;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        if (this.m_registry == itemRegistry) {
            return;
        }
        if (this.m_registry != null) {
            this.m_registry.removeDisplay(this);
        }
        this.m_registry = itemRegistry;
        if (itemRegistry != null) {
            this.m_registry.addDisplay(this);
        }
    }

    public void setTransform(AffineTransform affineTransform) throws NoninvertibleTransformException {
        this.m_transform = affineTransform;
        this.m_itransform = this.m_transform.createInverse();
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public AffineTransform getInverseTransform() {
        return this.m_itransform;
    }

    public Point2D getAbsoluteCoordinate(Point2D point2D, Point2D point2D2) {
        return this.m_itransform.transform(point2D, point2D2);
    }

    public double getScale() {
        return this.m_transform.getScaleX();
    }

    public double getDisplayX() {
        return -this.m_transform.getTranslateX();
    }

    public double getDisplayY() {
        return -this.m_transform.getTranslateY();
    }

    public void pan(double d, double d2) {
        double d3 = d / this.m_transform.getScaleX();
        double d4 = d2 / this.m_transform.getScaleY();
        this.panAbs(d3, d4);
    }

    public void panAbs(double d, double d2) {
        this.m_transform.translate(d, d2);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void panTo(Point2D point2D) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.panToAbs(this.m_tmpPoint);
    }

    public void panToAbs(Point2D point2D) {
        double d = point2D.getX();
        d = Double.isNaN(d) ? 0.0 : d;
        double d2 = point2D.getY();
        d2 = Double.isNaN(d2) ? 0.0 : d2;
        double d3 = (double)this.getWidth() / (2.0 * this.m_transform.getScaleX());
        double d4 = (double)this.getHeight() / (2.0 * this.m_transform.getScaleY());
        double d5 = d3 - d - this.m_transform.getTranslateX();
        double d6 = d4 - d2 - this.m_transform.getTranslateY();
        this.m_transform.translate(d5, d6);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void zoom(Point2D point2D, double d) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.zoomAbs(this.m_tmpPoint, d);
    }

    public void zoomAbs(Point2D point2D, double d) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        this.m_transform.translate(d2, d3);
        this.m_transform.scale(d, d);
        this.m_transform.translate(-d2, -d3);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void animatePan(double d, double d2, long l) {
        double d3 = d / this.m_transform.getScaleX();
        double d4 = d2 / this.m_transform.getScaleY();
        this.animatePanAbs(d3, d4, l);
    }

    public void animatePanAbs(double d, double d2, long l) {
        this.m_transact.pan(d, d2, l);
    }

    public void animatePanTo(Point2D point2D, long l) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animatePanToAbs(double_, l);
    }

    public void animatePanToAbs(Point2D point2D, long l) {
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double d = point2D.getX();
        d = Double.isNaN(d) ? 0.0 : d;
        double d2 = point2D.getY();
        d2 = Double.isNaN(d2) ? 0.0 : d2;
        double d3 = (double)this.getWidth() / (2.0 * this.m_transform.getScaleX());
        double d4 = (double)this.getHeight() / (2.0 * this.m_transform.getScaleY());
        double d5 = d3 - d + this.m_tmpPoint.getX();
        double d6 = d4 - d2 + this.m_tmpPoint.getY();
        this.animatePanAbs(d5, d6, l);
    }

    public void animateZoom(Point2D point2D, double d, long l) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animateZoomAbs(double_, d, l);
    }

    public void animateZoomAbs(Point2D point2D, double d, long l) {
        this.m_transact.zoom(point2D, d, l);
    }

    public void animatePanAndZoomTo(Point2D point2D, double d, long l) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animatePanAndZoomToAbs(double_, d, l);
    }

    public void animatePanAndZoomToAbs(Point2D point2D, double d, long l) {
        this.m_transact.panAndZoom(point2D, d, l);
    }

    public boolean isTranformInProgress() {
        return this.m_transact.isRunning();
    }

    public BufferedImage getOffscreenBuffer() {
        return this.m_offscreen;
    }

    protected BufferedImage getNewOffscreenBuffer() {
        return (BufferedImage)this.createImage(this.getSize().width, this.getSize().height);
    }

    public boolean saveImage(OutputStream outputStream, String string, double d) {
        try {
            Dimension dimension = new Dimension((int)(d * (double)this.getWidth()), (int)(d * (double)this.getHeight()));
            BufferedImage bufferedImage = (BufferedImage)this.createImage(dimension.width, dimension.height);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            this.zoom(double_, d);
            boolean bl = this.isHighQuality();
            this.setHighQuality(true);
            this.paintDisplay(graphics2D, dimension);
            this.setHighQuality(bl);
            this.zoom(double_, 1.0 / d);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void repaint() {
        if (!this.m_repaint) {
            this.m_repaint = true;
            super.repaint();
        }
    }

    protected void paintBufferToScreen(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        BufferedImage bufferedImage = this.m_offscreen;
        graphics.drawImage(bufferedImage, n, n2, null);
    }

    public void repaintImmediate() {
        Graphics graphics = this.getGraphics();
        if (graphics != null && this.m_offscreen != null) {
            this.paintBufferToScreen(graphics);
        }
    }

    protected void prepareGraphics(Graphics2D graphics2D) {
        if (this.m_transform != null) {
            graphics2D.transform(this.m_transform);
        }
        this.setRenderingHints(graphics2D);
    }

    protected void setRenderingHints(Graphics2D graphics2D) {
        if (this.m_highQuality) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    protected String getDebugString() {
        float f = (float)Math.round(this.frameRate * 100.0) / 100.0f;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() / 1000000L;
        long l2 = runtime.maxMemory() / 1000000L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("frame rate: ").append(f).append("fps - ");
        stringBuffer.append(this.m_registry.size()).append(" items (");
        stringBuffer.append(this.m_registry.size("node"));
        stringBuffer.append(" nodes, ");
        stringBuffer.append(this.m_registry.size("edge"));
        stringBuffer.append(" edges) fonts(").append(FontLib.getCacheMissCount());
        stringBuffer.append(") colors(");
        stringBuffer.append(ColorLib.getCacheMissCount()).append(')');
        stringBuffer.append(" mem(");
        stringBuffer.append(l).append("M / ");
        stringBuffer.append(l2).append("M)");
        stringBuffer.append(" (x:").append(this.numberString(this.m_transform.getTranslateX(), 2));
        stringBuffer.append(", y:").append(this.numberString(this.m_transform.getTranslateY(), 2));
        stringBuffer.append(", z:").append(this.numberString(this.getScale(), 5)).append(")");
        return stringBuffer.toString();
    }

    private String numberString(double d, int n) {
        String string = String.valueOf(d);
        int n2 = string.indexOf(".");
        if (n2 == -1) {
            return string;
        }
        int n3 = Math.min(string.length(), n2 + 1 + n);
        return string.substring(0, n3);
    }

    protected void prePaint(Graphics2D graphics2D) {
    }

    protected void postPaint(Graphics2D graphics2D) {
    }

    public void paintComponent(Graphics graphics) {
        if (this.m_offscreen == null) {
            this.m_offscreen = this.getNewOffscreenBuffer();
        }
        Graphics2D graphics2D = (Graphics2D)this.m_offscreen.getGraphics();
        this.paintDisplay(graphics2D, this.getSize());
        this.paintBufferToScreen(graphics);
        graphics2D.dispose();
        this.m_repaint = false;
        ++this.nframes;
        if (this.mark < 0L) {
            this.mark = System.currentTimeMillis();
            this.nframes = 0;
        } else if (this.nframes == this.sampleInterval) {
            long l = System.currentTimeMillis();
            this.frameRate = 1000.0 * (double)this.nframes / (double)(l - this.mark);
            this.mark = l;
            this.nframes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDisplay(Graphics2D graphics2D, Dimension dimension) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (this.m_showDebug) {
            graphics2D.setFont(this.getFont());
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(this.getDebugString(), 5, 15);
        }
        this.prepareGraphics(graphics2D);
        this.prePaint(graphics2D);
        graphics2D.setColor(Color.BLACK);
        ItemRegistry itemRegistry = this.m_registry;
        synchronized (itemRegistry) {
            this.m_clip.setClip(0.0, 0.0, dimension.width, dimension.height);
            this.m_clip.transform(this.m_itransform);
            Iterator iterator = this.m_registry.getItems();
            while (iterator.hasNext()) {
                try {
                    VisualItem visualItem = (VisualItem)iterator.next();
                    Renderer renderer = visualItem.getRenderer();
                    Rectangle2D rectangle2D = renderer.getBoundsRef(visualItem);
                    if (!this.m_clip.intersects(rectangle2D)) continue;
                    renderer.render(graphics2D, visualItem);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.postPaint(graphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printComponent(Graphics graphics) {
        boolean bl = this.m_highQuality;
        try {
            this.m_highQuality = true;
            this.paintDisplay((Graphics2D)graphics, this.getSize());
        }
        finally {
            this.m_highQuality = bl;
        }
    }

    public void clearRegion(Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)this.m_offscreen.getGraphics();
        if (graphics2D != null) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void drawItem(VisualItem visualItem) {
        Graphics2D graphics2D = (Graphics2D)this.m_offscreen.getGraphics();
        if (graphics2D != null) {
            this.prepareGraphics(graphics2D);
            visualItem.getRenderer().render(graphics2D, visualItem);
        }
    }

    public void addControlListener(ControlListener controlListener) {
        this.m_listener = ControlEventMulticaster.add(this.m_listener, controlListener);
    }

    public void removeControlListener(ControlListener controlListener) {
        this.m_listener = ControlEventMulticaster.remove(this.m_listener, controlListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualItem findItem(Point point) {
        Point point2 = this.m_itransform == null ? point : this.m_itransform.transform(point, this.m_tmpPoint);
        ItemRegistry itemRegistry = this.m_registry;
        synchronized (itemRegistry) {
            Iterator iterator = this.m_registry.getItemsReversed();
            while (iterator.hasNext()) {
                VisualItem visualItem = (VisualItem)iterator.next();
                Renderer renderer = visualItem.getRenderer();
                if (renderer == null || !visualItem.isInteractive() || !renderer.locatePoint(point2, visualItem)) continue;
                return visualItem;
            }
        }
        return null;
    }

    public JTextComponent getTextEditor() {
        return this.m_editor;
    }

    public void setTextEditor(JTextComponent jTextComponent) {
        this.remove(this.m_editor);
        this.m_editor = jTextComponent;
        this.add((Component)this.m_editor, 1);
    }

    public void editText(VisualItem visualItem, String string) {
        if (this.m_editing) {
            this.stopEditing();
        }
        Rectangle2D rectangle2D = visualItem.getBounds();
        Rectangle rectangle = this.m_transform.createTransformedShape(rectangle2D).getBounds();
        if (this.m_editor instanceof JTextArea) {
            rectangle.y -= 2;
            rectangle.width += 22;
            rectangle.height += 2;
        } else {
            rectangle.x += 3;
            ++rectangle.y;
            rectangle.width -= 5;
            rectangle.height -= 2;
        }
        Font font = this.getFont();
        int n = (int)Math.round((double)font.getSize() * this.m_transform.getScaleX());
        Font font2 = new Font(font.getFontName(), font.getStyle(), n);
        this.m_editor.setFont(font2);
        this.editText(visualItem, string, rectangle);
    }

    public void editText(VisualItem visualItem, String string, Rectangle rectangle) {
        if (this.m_editing) {
            this.stopEditing();
        }
        String string2 = visualItem.getAttribute(string);
        this.m_editItem = visualItem;
        this.m_editAttribute = string;
        Paint paint = visualItem.getColor();
        Paint paint2 = visualItem.getFillColor();
        if (paint instanceof Color) {
            this.m_editor.setForeground((Color)paint);
        }
        if (paint2 instanceof Color) {
            this.m_editor.setBackground((Color)paint2);
        }
        this.editText(string2, rectangle);
    }

    public void editText(String string, Rectangle rectangle) {
        if (this.m_editing) {
            this.stopEditing();
        }
        this.m_editing = true;
        this.m_editor.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.m_editor.setText(string);
        this.m_editor.setVisible(true);
        this.m_editor.setCaretPosition(string.length());
        this.m_editor.requestFocus();
    }

    public void stopEditing() {
        this.m_editor.setVisible(false);
        if (this.m_editItem != null) {
            String string = this.m_editor.getText();
            this.m_editItem.setAttribute(this.m_editAttribute, string);
            this.m_editItem = null;
            this.m_editAttribute = null;
            this.m_editor.setBackground(null);
            this.m_editor.setForeground(null);
        }
        this.m_editing = false;
    }

    public class InputEventCapturer
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener,
    KeyListener {
        private VisualItem activeVI = null;
        private boolean mouseDown = false;
        private boolean itemDrag = false;

        public void mouseDragged(MouseEvent mouseEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemDragged(this.activeVI, mouseEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.mouseDragged(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = false;
            VisualItem visualItem = Display.this.findItem(mouseEvent.getPoint());
            if (Display.this.m_listener != null && this.activeVI != null && this.activeVI != visualItem) {
                Display.this.m_listener.itemExited(this.activeVI, mouseEvent);
                bl = true;
            }
            if (Display.this.m_listener != null && visualItem != null && visualItem != this.activeVI) {
                Display.this.m_listener.itemEntered(visualItem, mouseEvent);
                bl = true;
            }
            this.activeVI = visualItem;
            if (bl) {
                return;
            }
            if (Display.this.m_listener != null && visualItem != null && visualItem == this.activeVI) {
                Display.this.m_listener.itemMoved(visualItem, mouseEvent);
            }
            if (Display.this.m_listener != null && visualItem == null) {
                Display.this.m_listener.mouseMoved(mouseEvent);
            }
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemWheelMoved(this.activeVI, mouseWheelEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.mouseWheelMoved(mouseWheelEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemClicked(this.activeVI, mouseEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.mouseClicked(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemPressed(this.activeVI, mouseEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemReleased(this.activeVI, mouseEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.mouseReleased(mouseEvent);
            }
            if (Display.this.m_listener != null && this.activeVI != null && this.mouseDown && this.isOffComponent(mouseEvent)) {
                Display.this.m_listener.itemExited(this.activeVI, mouseEvent);
                this.activeVI = null;
            }
            this.mouseDown = false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (Display.this.m_listener != null) {
                Display.this.m_listener.mouseEntered(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (Display.this.m_listener != null && !this.mouseDown && this.activeVI != null) {
                Display.this.m_listener.itemExited(this.activeVI, mouseEvent);
                this.activeVI = null;
            }
            if (Display.this.m_listener != null) {
                Display.this.m_listener.mouseExited(mouseEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemKeyPressed(this.activeVI, keyEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.keyPressed(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemKeyReleased(this.activeVI, keyEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.keyReleased(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (Display.this.m_listener != null && this.activeVI != null) {
                Display.this.m_listener.itemKeyTyped(this.activeVI, keyEvent);
            } else if (Display.this.m_listener != null) {
                Display.this.m_listener.keyTyped(keyEvent);
            }
        }

        private boolean isOffComponent(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            return n < 0 || n > Display.this.getWidth() || n2 < 0 || n2 > Display.this.getHeight();
        }
    }

    private class TransformActivity
    extends Activity {
        private double[] src = new double[6];
        private double[] dst = new double[6];
        private AffineTransform m_at = new AffineTransform();

        public TransformActivity() {
            super(2000L, 20L, 0L);
            this.setPacingFunction(new SlowInSlowOutPacer());
        }

        private AffineTransform getTransform() {
            if (this.isScheduled()) {
                this.m_at.setTransform(this.dst[0], this.dst[1], this.dst[2], this.dst[3], this.dst[4], this.dst[5]);
            } else {
                this.m_at.setTransform(Display.this.m_transform);
            }
            return this.m_at;
        }

        public void panAndZoom(Point2D point2D, double d, long l) {
            AffineTransform affineTransform = this.getTransform();
            this.cancel();
            this.setDuration(l);
            Display.this.m_tmpPoint.setLocation(0.0, 0.0);
            Display.this.m_itransform.transform(Display.this.m_tmpPoint, Display.this.m_tmpPoint);
            double d2 = point2D.getX();
            d2 = Double.isNaN(d2) ? 0.0 : d2;
            double d3 = point2D.getY();
            d3 = Double.isNaN(d3) ? 0.0 : d3;
            double d4 = (double)Display.this.getWidth() / (2.0 * Display.this.m_transform.getScaleX());
            double d5 = (double)Display.this.getHeight() / (2.0 * Display.this.m_transform.getScaleY());
            double d6 = d4 - d2 + Display.this.m_tmpPoint.getX();
            double d7 = d5 - d3 + Display.this.m_tmpPoint.getY();
            affineTransform.translate(d6, d7);
            affineTransform.translate(point2D.getX(), point2D.getY());
            affineTransform.scale(d, d);
            affineTransform.translate(-point2D.getX(), -point2D.getY());
            affineTransform.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.runNow();
        }

        public void pan(double d, double d2, long l) {
            AffineTransform affineTransform = this.getTransform();
            this.cancel();
            this.setDuration(l);
            affineTransform.translate(d, d2);
            affineTransform.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.runNow();
        }

        public void zoom(Point2D point2D, double d, long l) {
            AffineTransform affineTransform = this.getTransform();
            this.cancel();
            this.setDuration(l);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            affineTransform.translate(d2, d3);
            affineTransform.scale(d, d);
            affineTransform.translate(-d2, -d3);
            affineTransform.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.runNow();
        }

        protected void run(long l) {
            double d = this.getPace(l);
            Display.this.m_transform.setTransform(this.src[0] + d * (this.dst[0] - this.src[0]), this.src[1] + d * (this.dst[1] - this.src[1]), this.src[2] + d * (this.dst[2] - this.src[2]), this.src[3] + d * (this.dst[3] - this.src[3]), this.src[4] + d * (this.dst[4] - this.src[4]), this.src[5] + d * (this.dst[5] - this.src[5]));
            try {
                Display.this.m_itransform = Display.this.m_transform.createInverse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.this.repaint();
        }
    }
}

