/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.VisualItem;
import java.util.List;
import java.util.Map;

public class ItemFactory {
    private static final Class LIST_TYPE = class$java$util$LinkedList == null ? (class$java$util$LinkedList = ItemFactory.class$("java.util.LinkedList")) : class$java$util$LinkedList;
    private static final Class MAP_TYPE = class$java$util$HashMap == null ? (class$java$util$HashMap = ItemFactory.class$("java.util.HashMap")) : class$java$util$HashMap;
    private Map m_entryMap;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$HashMap;

    public ItemFactory() {
        try {
            this.m_entryMap = (Map)MAP_TYPE.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addItemClass(String string, Class clazz, int n) {
        FactoryEntry factoryEntry = new FactoryEntry(string, clazz, n);
        this.m_entryMap.put(string, factoryEntry);
    }

    public VisualItem getItem(String string) {
        FactoryEntry factoryEntry = (FactoryEntry)this.m_entryMap.get(string);
        if (factoryEntry != null) {
            VisualItem visualItem = null;
            if (factoryEntry.itemList.isEmpty()) {
                try {
                    visualItem = (VisualItem)factoryEntry.type.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                visualItem = (VisualItem)factoryEntry.itemList.remove(0);
            }
            return visualItem;
        }
        throw new IllegalArgumentException("The input string must be a recognized item class!");
    }

    public void reclaim(VisualItem visualItem) {
        String string = visualItem.getItemClass();
        FactoryEntry factoryEntry = (FactoryEntry)this.m_entryMap.get(string);
        visualItem.clear();
        if (factoryEntry.itemList.size() <= factoryEntry.maxItems) {
            factoryEntry.itemList.add(visualItem);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FactoryEntry {
        int maxItems;
        Class type;
        String name;
        List itemList;

        FactoryEntry(String string, Class clazz, int n) {
            try {
                this.maxItems = n;
                this.name = string;
                this.type = clazz;
                this.itemList = (List)LIST_TYPE.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

