/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.collections.NodeIterator;
import edu.berkeley.guir.prefuse.collections.WrapAroundIterator;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.GraphLib;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class NodeItem
extends VisualItem
implements TreeNode {
    private List m_edges = new ArrayList();
    private List m_children;
    private NodeItem m_parent;
    private EdgeItem m_parentEdge;
    private int m_numDescendants;

    public void init(ItemRegistry itemRegistry, String string, Entity entity) {
        if (entity != null && !(entity instanceof Node)) {
            throw new IllegalArgumentException("NodeItem can only represent an Entity of type Node.");
        }
        super.init(itemRegistry, string, entity);
    }

    public void clear() {
        super.clear();
        this.removeAllNeighbors();
    }

    private void nodeItemCheck(Node node) {
        if (node != null && !(node instanceof NodeItem)) {
            throw new IllegalArgumentException("Node must be an instance of NodeItem");
        }
    }

    private void edgeItemCheck(Edge edge) {
        if (edge != null && !(edge instanceof EdgeItem)) {
            throw new IllegalArgumentException("Edge must be an instance of EdgeItem");
        }
    }

    public boolean addEdge(Edge edge) {
        return this.addEdge(this.m_edges.size(), edge);
    }

    public boolean addEdge(int n, Edge edge) {
        this.edgeItemCheck(edge);
        if (edge.isDirected() && this != edge.getFirstNode()) {
            throw new IllegalArgumentException("Directed edges must have the source as the first node in the Edge.");
        }
        Node node = edge.getAdjacentNode(this);
        if (node == null) {
            throw new IllegalArgumentException("The Edge must be incident on this Node.");
        }
        if (this.isNeighbor(node)) {
            return false;
        }
        this.m_edges.add(n, edge);
        return true;
    }

    public Edge getEdge(int n) {
        return (Edge)this.m_edges.get(n);
    }

    public Edge getEdge(Node node) {
        this.nodeItemCheck(node);
        for (int i = 0; i < this.m_edges.size(); ++i) {
            Edge edge = (Edge)this.m_edges.get(i);
            if (node != edge.getAdjacentNode(this)) continue;
            return edge;
        }
        throw new NoSuchElementException();
    }

    public int getEdgeCount() {
        return this.m_edges.size();
    }

    public Iterator getEdges() {
        return this.m_edges.iterator();
    }

    public int getIndex(Edge edge) {
        this.edgeItemCheck(edge);
        return this.m_edges.indexOf(edge);
    }

    public int getIndex(Node node) {
        this.nodeItemCheck(node);
        for (int i = 0; i < this.m_edges.size(); ++i) {
            if (node != ((Edge)this.m_edges.get(i)).getAdjacentNode(this)) continue;
            return i;
        }
        return -1;
    }

    public Node getNeighbor(int n) {
        return ((Edge)this.m_edges.get(n)).getAdjacentNode(this);
    }

    public Iterator getNeighbors() {
        return new NodeIterator(this.m_edges.iterator(), this);
    }

    public boolean isIncidentEdge(Edge edge) {
        this.edgeItemCheck(edge);
        return this.m_edges.indexOf(edge) > -1;
    }

    public boolean isNeighbor(Node node) {
        this.nodeItemCheck(node);
        return this.getIndex(node) > -1;
    }

    public void removeAllNeighbors() {
        if (this.m_children != null) {
            this.m_children.clear();
        }
        this.m_parentEdge = null;
        this.m_parent = null;
        this.m_edges.clear();
    }

    public boolean removeEdge(Edge edge) {
        int n;
        this.edgeItemCheck(edge);
        if (edge == this.m_parentEdge) {
            this.m_parent = null;
            this.m_parentEdge = null;
        } else if (this.m_children != null && (n = this.m_children.indexOf(edge)) > -1) {
            this.m_children.remove(n);
        }
        n = this.m_edges.indexOf(edge);
        return n > -1 ? this.m_edges.remove(n) != null : false;
    }

    public Edge removeEdge(int n) {
        Edge edge = (Edge)this.m_edges.remove(n);
        if (edge == this.m_parentEdge) {
            this.m_parent = null;
            this.m_parentEdge = null;
        } else if (this.m_children != null && (n = this.m_children.indexOf(edge)) > -1) {
            this.m_children.remove(n);
        }
        return edge;
    }

    public boolean removeNeighbor(Node node) {
        this.nodeItemCheck(node);
        for (int i = 0; i < this.m_edges.size(); ++i) {
            if (node != ((Edge)this.m_edges.get(i)).getAdjacentNode(this)) continue;
            return this.m_edges.remove(i) != null;
        }
        return false;
    }

    public Node removeNeighbor(int n) {
        return this.removeEdge(n).getAdjacentNode(this);
    }

    public boolean addChild(Edge edge) {
        int n = this.m_children == null ? 0 : this.m_children.size();
        return this.addChild(n, edge);
    }

    public boolean addChild(int n, Edge edge) {
        this.edgeItemCheck(edge);
        Node node = edge.getAdjacentNode(this);
        if (node == null || edge.isDirected() || !(node instanceof TreeNode)) {
            throw new IllegalArgumentException("Not a valid, connecting tree edge!");
        }
        TreeNode treeNode = (TreeNode)node;
        if (this.getIndex(treeNode) > -1) {
            return false;
        }
        if (this.getChildIndex(treeNode) > -1) {
            return false;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList(3);
        }
        int n2 = n > 0 ? this.getIndex(this.getChild(n - 1)) + 1 : 0;
        this.addEdge(n2, edge);
        this.m_children.add(n, edge);
        treeNode.addEdge(edge);
        treeNode.setParentEdge(edge);
        int n3 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() + n3);
        }
        return true;
    }

    public TreeNode getChild(int n) {
        if (this.m_children == null || n < 0 || n >= this.m_children.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (TreeNode)((Edge)this.m_children.get(n)).getAdjacentNode(this);
    }

    public int getChildCount() {
        return this.m_children == null ? 0 : this.m_children.size();
    }

    public Edge getChildEdge(int n) {
        if (this.m_children == null || n < 0 || n >= this.m_children.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Edge)this.m_children.get(n);
    }

    public int getChildIndex(Edge edge) {
        this.edgeItemCheck(edge);
        return this.m_children == null ? -1 : this.m_children.indexOf(edge);
    }

    public int getChildIndex(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.size(); ++i) {
                if (treeNode != ((Edge)this.m_children.get(i)).getAdjacentNode(this)) continue;
                return i;
            }
        }
        return -1;
    }

    public Iterator getChildEdges() {
        int n;
        if (this.m_children == null || this.m_children.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        int n2 = n = this.m_parent == null ? 0 : GraphLib.nearestIndex(this, this.m_parent) % this.m_children.size();
        if (n == 0) {
            return this.m_children.iterator();
        }
        return new WrapAroundIterator(this.m_children, n);
    }

    public Iterator getChildren() {
        return new NodeIterator(this.getChildEdges(), this);
    }

    public int getDescendantCount() {
        return this.m_numDescendants;
    }

    public TreeNode getNextSibling() {
        int n = this.m_parent.getChildIndex(this) + 1;
        return n == this.m_parent.getChildCount() ? null : this.m_parent.getChild(n);
    }

    public TreeNode getParent() {
        return this.m_parent;
    }

    public Edge getParentEdge() {
        return this.m_parentEdge;
    }

    public TreeNode getPreviousSibling() {
        int n = this.m_parent.getChildIndex(this);
        return n == 0 ? null : this.m_parent.getChild(n - 1);
    }

    public boolean isChild(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        return this.getChildIndex(treeNode) >= 0;
    }

    public boolean isChildEdge(Edge edge) {
        this.edgeItemCheck(edge);
        return this.m_children == null ? false : this.m_children.indexOf(edge) > -1;
    }

    public boolean isDescendant(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        while (treeNode != null) {
            if (this == treeNode) {
                return true;
            }
            treeNode = treeNode.getParent();
        }
        return false;
    }

    public boolean isSibling(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        return this != treeNode && this.getParent() == treeNode.getParent();
    }

    public void removeAllAsChildren() {
        if (this.m_children == null) {
            return;
        }
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)((Edge)iterator.next()).getAdjacentNode(this);
            treeNode.setParentEdge(null);
        }
        this.m_children.clear();
        int n = this.m_numDescendants;
        for (TreeNode treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            treeNode.setDescendantCount(treeNode.getDescendantCount() - n);
        }
    }

    public void removeAllChildren() {
        TreeNode treeNode;
        if (this.m_children == null) {
            return;
        }
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            treeNode = (TreeNode)edge.getAdjacentNode(this);
            treeNode.setParentEdge(null);
            treeNode.removeNeighbor(this);
            this.removeEdge(edge);
        }
        this.m_children.clear();
        int n = this.m_numDescendants;
        for (treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            treeNode.setDescendantCount(treeNode.getDescendantCount() - n);
        }
    }

    public boolean removeAsChild(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        return this.removeAsChild(this.getChildIndex(treeNode)) != null;
    }

    public TreeNode removeAsChild(int n) {
        if (n < 0 || n >= this.getChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        Edge edge = (Edge)this.m_children.remove(n);
        TreeNode treeNode = (TreeNode)edge.getAdjacentNode(this);
        treeNode.setParentEdge(null);
        int n2 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() - n2);
        }
        return treeNode;
    }

    public boolean removeChild(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        return this.removeChild(this.getChildIndex(treeNode)) != null;
    }

    public TreeNode removeChild(int n) {
        TreeNode treeNode = this.removeAsChild(n);
        treeNode.removeNeighbor(this);
        return treeNode;
    }

    public boolean removeChildEdge(Edge edge) {
        this.edgeItemCheck(edge);
        return this.removeChildEdge(this.getChildIndex(edge)) != null;
    }

    public Edge removeChildEdge(int n) {
        if (n < 0 || n >= this.getChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        Edge edge = (Edge)this.m_children.remove(n);
        TreeNode treeNode = (TreeNode)edge.getAdjacentNode(this);
        treeNode.setParentEdge(null);
        treeNode.removeEdge(edge);
        int n2 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() - n2);
        }
        return edge;
    }

    public boolean setAsChild(TreeNode treeNode) {
        this.nodeItemCheck(treeNode);
        int n = this.m_children == null ? 0 : this.m_children.size();
        return this.setAsChild(n, treeNode);
    }

    public boolean setAsChild(int n, TreeNode treeNode) {
        int n2;
        this.nodeItemCheck(treeNode);
        int n3 = this.getIndex(treeNode);
        if (n3 < 0) {
            throw new IllegalStateException("Node is not already a neighbor!");
        }
        if (this.getChildIndex(treeNode) > -1) {
            return false;
        }
        int n4 = n2 = this.m_children == null ? 0 : this.m_children.size();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList(3);
        }
        Edge edge = this.getEdge(n3);
        this.m_children.add(n, edge);
        treeNode.setParentEdge(edge);
        int n5 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() + n5);
        }
        return true;
    }

    public void setDescendantCount(int n) {
        this.m_numDescendants = n;
    }

    public void setParentEdge(Edge edge) {
        this.edgeItemCheck(edge);
        this.m_parentEdge = (EdgeItem)edge;
        this.m_parent = edge == null ? null : (NodeItem)edge.getAdjacentNode(this);
    }

    public int getDepth() {
        int n = 0;
        NodeItem nodeItem = this;
        while ((nodeItem = (NodeItem)nodeItem.getParent()) != null) {
            ++n;
        }
        return n;
    }
}

