/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.animate;

import edu.berkeley.guir.prefuse.AggregateItem;
import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.AbstractAction;
import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PolarLocationAnimator
extends AbstractAction
implements FocusListener {
    private static final double TWO_PI = Math.PI * 2;
    private Point2D m_anchor = new Point2D.Double();
    private Set m_linear = new HashSet();
    private ItemRegistry m_registry;

    private Point2D getAnchor(ItemRegistry itemRegistry) {
        Display display = itemRegistry.getDisplay(0);
        this.m_anchor.setLocation(display.getWidth() / 2, display.getHeight() / 2);
        display.getAbsoluteCoordinate(this.m_anchor, this.m_anchor);
        return this.m_anchor;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        if (itemRegistry != this.m_registry) {
            if (this.m_registry != null) {
                this.m_registry.getDefaultFocusSet().removeFocusListener(this);
            }
            this.m_registry = itemRegistry;
            this.m_registry.getDefaultFocusSet().addFocusListener(this);
        }
        Point2D point2D = this.getAnchor(itemRegistry);
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        Iterator iterator = this.m_registry.getItems();
        while (iterator.hasNext()) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            VisualItem visualItem = (VisualItem)iterator.next();
            Point2D point2D2 = visualItem.getStartLocation();
            Point2D point2D3 = visualItem.getEndLocation();
            double d13 = point2D2.getX() - d2;
            double d14 = point2D2.getY() - d3;
            double d15 = point2D3.getX() - d2;
            double d16 = point2D3.getY() - d3;
            if (this.m_linear.contains(visualItem)) {
                d12 = point2D2.getX() + d * (point2D3.getX() - point2D2.getX());
                d11 = point2D2.getY() + d * (point2D3.getY() - point2D2.getY());
                visualItem.setLocation(d12, d11);
            } else {
                double d17 = Math.sqrt(d13 * d13 + d14 * d14);
                if (visualItem instanceof NodeItem && Double.isNaN(d17)) {
                    d17 = Math.sqrt(d13 * d13 + d14 * d14);
                }
                d10 = Math.atan2(d14, d13);
                double d18 = Math.sqrt(d15 * d15 + d16 * d16);
                if (visualItem instanceof NodeItem && Double.isNaN(d18)) {
                    d18 = Math.sqrt(d15 * d15 + d16 * d16);
                }
                d9 = Math.atan2(d16, d15);
                d8 = this.translate(d10);
                d7 = this.translate(d9);
                d6 = d9 - d10;
                d5 = d7 - d8;
                d4 = Math.abs(d6) < Math.abs(d5) ? d10 + d * d6 : d8 + d * d5;
                double d19 = d17 + d * (d18 - d17);
                d12 = Math.round(d2 + d19 * Math.cos(d4));
                d11 = Math.round(d3 + d19 * Math.sin(d4));
                visualItem.setLocation(d12, d11);
            }
            if (!(visualItem instanceof AggregateItem)) continue;
            AggregateItem aggregateItem = (AggregateItem)visualItem;
            d10 = aggregateItem.getStartOrientation();
            d9 = aggregateItem.getEndOrientation();
            d8 = this.translate(d10);
            d7 = this.translate(d9);
            d6 = d9 - d10;
            d5 = d7 - d8;
            d4 = Math.abs(d6) < Math.abs(d5) ? d10 + d * d6 : d8 + d * d5;
            aggregateItem.setOrientation(d4);
        }
    }

    private double translate(double d) {
        return d < 0.0 ? d + Math.PI * 2 : d;
    }

    public void focusChanged(FocusEvent focusEvent) {
        if (focusEvent.getEventType() == 2) {
            this.m_linear.clear();
            Entity[] entityArray = focusEvent.getRemovedFoci();
            if (entityArray.length == 0) {
                return;
            }
            if (entityArray[0] instanceof Node) {
                for (TreeNode treeNode = this.m_registry.getNodeItem((Node)entityArray[0]); treeNode != null; treeNode = treeNode.getParent()) {
                    this.m_linear.add(treeNode);
                }
            }
        }
    }
}

