/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.activity;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.activity.Activity;
import java.util.ArrayList;
import java.util.Iterator;

public class ActionList
extends Activity
implements Action {
    private ItemRegistry m_registry;
    private ArrayList m_actions = new ArrayList();

    public ActionList(ItemRegistry itemRegistry) {
        this(itemRegistry, 0L);
    }

    public ActionList(ItemRegistry itemRegistry, long l) {
        this(itemRegistry, l, 20L);
    }

    public ActionList(ItemRegistry itemRegistry, long l, long l2) {
        this(itemRegistry, l, l2, System.currentTimeMillis());
    }

    public ActionList(ItemRegistry itemRegistry, long l, long l2, long l3) {
        super(l, l2, l3);
        this.m_registry = itemRegistry;
    }

    public synchronized int size() {
        return this.m_actions.size();
    }

    public synchronized void add(Action action) {
        this.m_actions.add(action);
    }

    public synchronized void add(int n, Action action) {
        this.m_actions.add(n, action);
    }

    public synchronized Action get(int n) {
        return (Action)this.m_actions.get(n);
    }

    public synchronized boolean remove(Action action) {
        return this.m_actions.remove(action);
    }

    public synchronized Action remove(int n) {
        return (Action)this.m_actions.remove(n);
    }

    protected synchronized void run(long l) {
        this.run(this.m_registry, this.getPace(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ItemRegistry itemRegistry, double d) {
        ItemRegistry itemRegistry2 = this.m_registry;
        synchronized (itemRegistry2) {
            Iterator iterator = this.m_actions.iterator();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                try {
                    if (!action.isEnabled()) continue;
                    action.run(this.m_registry, d);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

