/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.activity;

import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ActivityAdapter;
import java.util.ArrayList;

public class ActivityManager
extends Thread {
    private static ActivityManager s_instance;
    private ArrayList m_activities = new ArrayList();
    private ArrayList m_tmp = new ArrayList();
    private long m_nextTime = Long.MAX_VALUE;
    private boolean m_stop = false;

    private static ActivityManager getInstance() {
        if (s_instance == null || !s_instance.isAlive()) {
            s_instance = new ActivityManager();
        }
        return s_instance;
    }

    private ActivityManager() {
        super("prefuse_ActivityManager");
        this.setDaemon(true);
        this.start();
    }

    public static void kill() {
        ActivityManager activityManager = ActivityManager.getInstance();
        if (activityManager.isAlive()) {
            ActivityManager.getInstance()._stop();
        }
    }

    static void schedule(Activity activity) {
        ActivityManager.getInstance()._schedule(activity);
    }

    static void scheduleNow(Activity activity) {
        ActivityManager.getInstance()._scheduleNow(activity);
    }

    static void scheduleAt(Activity activity, long l) {
        ActivityManager.getInstance()._scheduleAt(activity, l);
    }

    static void scheduleAfter(Activity activity, Activity activity2) {
        ActivityManager.getInstance()._scheduleAfter(activity, activity2);
    }

    static void alwaysScheduleAfter(Activity activity, Activity activity2) {
        ActivityManager.getInstance()._alwaysScheduleAfter(activity, activity2);
    }

    static void removeActivity(Activity activity) {
        ActivityManager.getInstance()._removeActivity(activity);
    }

    public static int activityCount() {
        return ActivityManager.getInstance()._activityCount();
    }

    private synchronized void _stop() {
        this.m_stop = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _schedule(Activity activity) {
        if (activity.isScheduled()) {
            return;
        }
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.m_activities.add(activity);
            activity.setScheduled(true);
            long l = activity.getStartTime();
            if (l < this.m_nextTime) {
                this.m_nextTime = l;
                this.notify();
            }
        }
    }

    private void _scheduleAt(Activity activity, long l) {
        if (activity.isScheduled()) {
            return;
        }
        activity.setStartTime(l);
        ActivityManager.schedule(activity);
    }

    private void _scheduleNow(Activity activity) {
        if (activity.isScheduled()) {
            return;
        }
        activity.setStartTime(System.currentTimeMillis());
        ActivityManager.schedule(activity);
    }

    private void _scheduleAfter(Activity activity, Activity activity2) {
        activity.addActivityListener(new ScheduleAfterActivity(activity2, true));
    }

    private void _alwaysScheduleAfter(Activity activity, Activity activity2) {
        activity.addActivityListener(new ScheduleAfterActivity(activity2, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _removeActivity(Activity activity) {
        boolean bl;
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            bl = this.m_activities.remove(activity);
            if (bl && this.m_activities.size() == 0) {
                this.m_nextTime = Long.MAX_VALUE;
            }
        }
        if (bl) {
            activity.setScheduled(false);
        }
        return bl;
    }

    private synchronized int _activityCount() {
        return this.m_activities.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.m_stop) {
            if (ActivityManager.activityCount() > 0) {
                long l = System.currentTimeMillis();
                long l2 = -1L;
                ActivityManager activityManager = this;
                synchronized (activityManager) {
                    this.m_tmp.addAll(this.m_activities);
                }
                for (int i = 0; i < this.m_tmp.size(); ++i) {
                    Activity activity = (Activity)this.m_tmp.get(i);
                    long l3 = activity.runActivity(l);
                    l2 = l3 < 0L ? l2 : (l2 < 0L ? l3 : Math.min(l2, l3));
                }
                this.m_tmp.clear();
                if (l2 == -1L) continue;
                ActivityManager activityManager2 = this;
                synchronized (activityManager2) {
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                ActivityManager activityManager = this;
                synchronized (activityManager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.m_nextTime = Long.MAX_VALUE;
        this.m_stop = false;
        s_instance = null;
    }

    public class ScheduleAfterActivity
    extends ActivityAdapter {
        Activity after;
        boolean remove;

        public ScheduleAfterActivity(Activity activity, boolean bl) {
            this.after = activity;
            this.remove = bl;
        }

        public void activityFinished(Activity activity) {
            if (this.remove) {
                activity.removeActivityListener(this);
            }
            ActivityManager.scheduleNow(this.after);
        }

        public void activityCancelled(Activity activity) {
            if (this.remove) {
                activity.removeActivityListener(this);
            }
        }
    }
}

