/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.collections;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.collections.ReverseListIterator;
import edu.berkeley.guir.prefuse.collections.VisibleItemIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompositeItemIterator
implements Iterator {
    private Iterator[] m_iter;
    private Object[] m_item;
    private Comparator m_comp;
    private boolean m_reverse;
    private int m_emptyCount;

    public CompositeItemIterator(List list, Comparator comparator, boolean bl, boolean bl2) {
        int n = list.size();
        this.m_emptyCount = 0;
        this.m_iter = new Iterator[n];
        this.m_item = new Object[n];
        for (int i = 0; i < n; ++i) {
            List list2 = ((ItemRegistry.ItemEntry)list.get(i)).getItemList();
            this.m_iter[i] = bl ? new VisibleItemIterator(list2, bl2) : (bl2 ? new ReverseListIterator(list2) : list2.iterator());
            if (this.m_iter[i].hasNext()) {
                this.m_item[i] = this.m_iter[i].next();
                continue;
            }
            ++this.m_emptyCount;
        }
        this.m_reverse = bl2;
        this.m_comp = comparator;
    }

    public boolean hasNext() {
        return this.m_emptyCount < this.m_item.length;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = -1;
        for (int i = 0; i < this.m_item.length; ++i) {
            if (this.m_item[i] == null) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            int n2 = this.m_comp.compare(this.m_item[n], this.m_item[i]);
            if (this.m_reverse) {
                n2 *= -1;
            }
            n = n2 < 0 ? n : i;
        }
        Object object = null;
        try {
            object = this.m_item[n];
        }
        catch (Exception exception) {
            System.out.println("");
        }
        Object object2 = this.m_item[n] = this.m_iter[n].hasNext() ? (Object)this.m_iter[n].next() : null;
        if (this.m_item[n] == null) {
            ++this.m_emptyCount;
        }
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

