/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.event;

import edu.berkeley.guir.prefuse.Display;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PrefuseEventPlayback {
    private static HashSet s_mouseEvents = new HashSet();
    private static HashSet s_keyEvents = new HashSet();
    private Display display;
    private List events;
    private long startTime;

    public PrefuseEventPlayback(Display display, String string) {
        this.display = display;
        this.events = new ArrayList();
        try {
            this.parseLogFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void play() {
        Runnable runnable = new Runnable(){

            public void run() {
                PrefuseEventPlayback.this.playInternal();
            }
        };
        new Thread(runnable).start();
    }

    public void playInternal() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        long l = System.currentTimeMillis();
        long l2 = this.startTime;
        int n = 0;
        while (n < this.events.size()) {
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l;
            l = l3;
            l2 += l4;
            EventEntry eventEntry = (EventEntry)this.events.get(n);
            while (eventEntry != null && eventEntry.time < l2) {
                AWTEvent aWTEvent = this.getEvent(l3, eventEntry.event);
                eventQueue.postEvent(aWTEvent);
                if (n < this.events.size() - 1) {
                    eventEntry = (EventEntry)this.events.get(++n);
                    continue;
                }
                ++n;
                eventEntry = null;
            }
            if (eventEntry == null) continue;
            long l5 = eventEntry.time - l2;
            try {
                Thread.sleep(l5);
            }
            catch (Exception exception) {}
        }
    }

    private void parseLogFile(String string) throws IOException {
        String string2;
        this.startTime = -1L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            this.parseLine(string2);
        }
        bufferedReader.close();
    }

    private void parseLine(String string) {
        String[] stringArray = string.split("\t");
        long l = Long.parseLong(stringArray[0]);
        if (this.startTime == -1L) {
            this.startTime = l;
        }
        boolean bl = s_mouseEvents.contains(stringArray[1]);
        boolean bl2 = s_keyEvents.contains(stringArray[1]);
        if (bl || bl2) {
            String string2 = null;
            for (int i = 2; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("[")) continue;
                string2 = stringArray[i];
            }
            EventParams eventParams = null;
            eventParams = bl ? this.parseMouseEvent(l, string2) : this.parseKeyEvent(l, string2);
            this.events.add(new EventEntry(l, eventParams));
        }
    }

    public AWTEvent getEvent(long l, EventParams eventParams) {
        if (eventParams instanceof MouseParams) {
            return this.getMouseEvent(l, (MouseParams)eventParams);
        }
        if (eventParams instanceof KeyParams) {
            return this.getKeyEvent(l, (KeyParams)eventParams);
        }
        return null;
    }

    public MouseEvent getMouseEvent(long l, MouseParams mouseParams) {
        if (mouseParams.id != 507) {
            return new MouseEvent(this.display, mouseParams.id, l, mouseParams.modifiers, mouseParams.x, mouseParams.y, mouseParams.clickCount, false, mouseParams.button);
        }
        return new MouseWheelEvent((Component)this.display, mouseParams.id, l, mouseParams.modifiers, mouseParams.x, mouseParams.y, mouseParams.clickCount, false, mouseParams.scrollType, mouseParams.scrollAmount, mouseParams.wheelRotation);
    }

    public KeyEvent getKeyEvent(long l, KeyParams keyParams) {
        return new KeyEvent(this.display, keyParams.id, l, keyParams.modifiers, keyParams.keyCode, keyParams.keyChar);
    }

    public MouseParams parseMouseEvent(long l, String string) {
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        MouseParams mouseParams = new MouseParams();
        mouseParams.id = Integer.parseInt(this.getValue(stringArray[0]));
        mouseParams.x = Integer.parseInt(this.getValue(stringArray[1]));
        mouseParams.y = Integer.parseInt(this.getValue(stringArray[2]));
        mouseParams.button = Integer.parseInt(this.getValue(stringArray[3]));
        mouseParams.clickCount = Integer.parseInt(this.getValue(stringArray[4]));
        mouseParams.modifiers = Integer.parseInt(this.getValue(stringArray[5]));
        if (mouseParams.id == 507) {
            mouseParams.scrollType = Integer.parseInt(this.getValue(stringArray[6]));
            mouseParams.scrollAmount = Integer.parseInt(this.getValue(stringArray[7]));
            mouseParams.wheelRotation = Integer.parseInt(this.getValue(stringArray[8]));
        }
        return mouseParams;
    }

    public KeyParams parseKeyEvent(long l, String string) {
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        KeyParams keyParams = new KeyParams();
        keyParams.id = Integer.parseInt(this.getValue(stringArray[0]));
        keyParams.keyCode = Integer.parseInt(this.getValue(stringArray[1]));
        keyParams.keyChar = this.getValue(stringArray[2]).charAt(0);
        keyParams.modifiers = Integer.parseInt(this.getValue(stringArray[3]));
        return null;
    }

    private String getValue(String string) {
        return string.substring(string.indexOf("=") + 1);
    }

    static {
        s_mouseEvents.add("ITEM-DRAGGED");
        s_mouseEvents.add("ITEM-MOVED");
        s_mouseEvents.add("ITEM-WHEEL-MOVED");
        s_mouseEvents.add("ITEM-CLICKED");
        s_mouseEvents.add("ITEM-PRESSED");
        s_mouseEvents.add("ITEM-RELEASED");
        s_mouseEvents.add("ITEM-ENTERED");
        s_mouseEvents.add("ITEM-EXITED");
        s_mouseEvents.add("MOUSE-ENTERED");
        s_mouseEvents.add("MOUSE-EXITED");
        s_mouseEvents.add("MOUSE-PRESSED");
        s_mouseEvents.add("MOUSE-RELEASED");
        s_mouseEvents.add("MOUSE-CLICKED");
        s_mouseEvents.add("MOUSE-DRAGGED");
        s_mouseEvents.add("MOUSE-MOVED");
        s_mouseEvents.add("MOUSE-WHEEL-MOVED");
        s_keyEvents.add("KEY-PRESSED");
        s_keyEvents.add("KEY-RELEASED");
        s_keyEvents.add("KEY-TYPED");
        s_keyEvents.add("ITEM-KEY-PRESSED");
        s_keyEvents.add("ITEM-KEY-RELEASED");
        s_keyEvents.add("ITEM-KEY-TYPED");
    }

    public class KeyParams
    extends EventParams {
        int keyCode;
        char keyChar;
    }

    public class MouseParams
    extends EventParams {
        int x;
        int y;
        int button;
        int clickCount;
        int scrollType;
        int scrollAmount;
        int wheelRotation;
    }

    public class EventParams {
        int id;
        int modifiers;
    }

    public class EventEntry {
        long time;
        EventParams event;

        public EventEntry(long l, EventParams eventParams) {
            this.time = l;
            this.event = eventParams;
        }
    }
}

