/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.collections.NodeIterator;
import edu.berkeley.guir.prefuse.collections.WrapAroundIterator;
import edu.berkeley.guir.prefuse.graph.DefaultNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.GraphLib;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultTreeNode
extends DefaultNode
implements TreeNode {
    protected List m_children;
    protected int m_numDescendants = 0;
    protected TreeNode m_parent;
    protected Edge m_parentEdge;

    public DefaultTreeNode() {
        this.m_parentEdge = null;
        this.m_parent = null;
    }

    public DefaultTreeNode(Edge edge) {
        ((TreeNode)edge.getAdjacentNode(this)).addChild(edge);
    }

    public boolean addChild(Edge edge) {
        int n = this.m_children == null ? 0 : this.m_children.size();
        return this.addChild(n, edge);
    }

    public boolean addChild(int n, Edge edge) {
        Node node = edge.getAdjacentNode(this);
        if (node == null || edge.isDirected() || !(node instanceof TreeNode)) {
            throw new IllegalArgumentException("Not a valid, connecting tree edge!");
        }
        TreeNode treeNode = (TreeNode)node;
        if (this.getIndex(treeNode) > -1) {
            throw new IllegalStateException("Node is already a neighbor.");
        }
        if (this.getChildIndex(treeNode) > -1) {
            return false;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList(3);
        }
        int n2 = n > 0 ? this.getIndex(this.getChild(n - 1)) + 1 : 0;
        super.addEdge(n2, edge);
        this.m_children.add(n, edge);
        treeNode.addEdge(edge);
        treeNode.setParentEdge(edge);
        int n3 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() + n3);
        }
        return true;
    }

    public TreeNode getChild(int n) {
        if (this.m_children == null || n < 0 || n >= this.m_children.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (TreeNode)((Edge)this.m_children.get(n)).getAdjacentNode(this);
    }

    public int getChildCount() {
        return this.m_children == null ? 0 : this.m_children.size();
    }

    public Edge getChildEdge(int n) {
        if (this.m_children == null || n < 0 || n >= this.m_children.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Edge)this.m_children.get(n);
    }

    public int getChildIndex(Edge edge) {
        return this.m_children == null ? -1 : this.m_children.indexOf(edge);
    }

    public int getChildIndex(TreeNode treeNode) {
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.size(); ++i) {
                if (treeNode != ((Edge)this.m_children.get(i)).getAdjacentNode(this)) continue;
                return i;
            }
        }
        return -1;
    }

    public Iterator getChildEdges() {
        int n;
        if (this.m_children == null || this.m_children.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        int n2 = n = this.m_parent == null ? 0 : GraphLib.nearestIndex(this, this.m_parent) % this.m_children.size();
        if (n == 0) {
            return this.m_children.iterator();
        }
        return new WrapAroundIterator(this.m_children, n);
    }

    public Iterator getChildren() {
        return new NodeIterator(this.getChildEdges(), this);
    }

    public int getDescendantCount() {
        return this.m_numDescendants;
    }

    public TreeNode getNextSibling() {
        int n = this.m_parent.getChildIndex(this) + 1;
        return n == this.m_parent.getChildCount() ? null : this.m_parent.getChild(n);
    }

    public TreeNode getParent() {
        return this.m_parent;
    }

    public Edge getParentEdge() {
        return this.m_parentEdge;
    }

    public TreeNode getPreviousSibling() {
        int n = this.m_parent.getChildIndex(this);
        return n == 0 ? null : this.m_parent.getChild(n - 1);
    }

    public boolean isChild(TreeNode treeNode) {
        return this.getChildIndex(treeNode) >= 0;
    }

    public boolean isChildEdge(Edge edge) {
        return this.m_children == null ? false : this.m_children.indexOf(edge) > -1;
    }

    public boolean isDescendant(TreeNode treeNode) {
        while (treeNode != null) {
            if (this == treeNode) {
                return true;
            }
            treeNode = treeNode.getParent();
        }
        return false;
    }

    public boolean isSibling(TreeNode treeNode) {
        return this != treeNode && this.getParent() == treeNode.getParent();
    }

    public void removeAllAsChildren() {
        if (this.m_children == null) {
            return;
        }
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)((Edge)iterator.next()).getAdjacentNode(this);
            treeNode.setParentEdge(null);
        }
        this.m_children.clear();
        int n = this.m_numDescendants;
        for (TreeNode treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            treeNode.setDescendantCount(treeNode.getDescendantCount() - n);
        }
    }

    public void removeAllChildren() {
        TreeNode treeNode;
        if (this.m_children == null) {
            return;
        }
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            treeNode = (TreeNode)edge.getAdjacentNode(this);
            treeNode.setParentEdge(null);
            treeNode.removeNeighbor(this);
            this.removeEdge(edge);
        }
        this.m_children.clear();
        int n = this.m_numDescendants;
        for (treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            treeNode.setDescendantCount(treeNode.getDescendantCount() - n);
        }
    }

    public boolean removeAsChild(TreeNode treeNode) {
        return this.removeAsChild(this.getChildIndex(treeNode)) != null;
    }

    public TreeNode removeAsChild(int n) {
        if (n < 0 || n >= this.getChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        Edge edge = (Edge)this.m_children.remove(n);
        TreeNode treeNode = (TreeNode)edge.getAdjacentNode(this);
        treeNode.setParentEdge(null);
        int n2 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() - n2);
        }
        return treeNode;
    }

    public boolean removeChild(TreeNode treeNode) {
        return this.removeChildAndNeighbor(this.getChildIndex(treeNode)) != null;
    }

    public TreeNode removeChild(int n) {
        return this.removeChildAndNeighbor(n);
    }

    private TreeNode removeChildAndNeighbor(int n) {
        super.removeEdge(super.getEdge(this.getChild(n)));
        TreeNode treeNode = this.removeAsChild(n);
        treeNode.removeNeighbor(this);
        return treeNode;
    }

    public boolean removeChildEdge(Edge edge) {
        return this.removeChildEdge(this.getChildIndex(edge)) != null;
    }

    public Edge removeChildEdge(int n) {
        if (n < 0 || n >= this.getChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        Edge edge = (Edge)this.m_children.remove(n);
        TreeNode treeNode = (TreeNode)edge.getAdjacentNode(this);
        treeNode.setParentEdge(null);
        treeNode.removeEdge(edge);
        int n2 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() - n2);
        }
        return edge;
    }

    public boolean setAsChild(TreeNode treeNode) {
        int n = this.m_children == null ? 0 : this.m_children.size();
        return this.setAsChild(n, treeNode);
    }

    public boolean setAsChild(int n, TreeNode treeNode) {
        int n2;
        int n3 = this.getIndex(treeNode);
        if (n3 < 0) {
            throw new IllegalStateException("Node is not already a neighbor!");
        }
        if (this.getChildIndex(treeNode) > -1) {
            return false;
        }
        int n4 = n2 = this.m_children == null ? 0 : this.m_children.size();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList(3);
        }
        Edge edge = this.getEdge(n3);
        this.m_children.add(n, edge);
        treeNode.setParentEdge(edge);
        int n5 = 1 + treeNode.getDescendantCount();
        for (TreeNode treeNode2 = this; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            treeNode2.setDescendantCount(treeNode2.getDescendantCount() + n5);
        }
        return true;
    }

    public void setDescendantCount(int n) {
        this.m_numDescendants = n;
    }

    public void setParentEdge(Edge edge) {
        this.m_parentEdge = edge;
        this.m_parent = edge == null ? null : (TreeNode)edge.getAdjacentNode(this);
    }
}

