/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.collections.BreadthFirstGraphIterator;
import edu.berkeley.guir.prefuse.collections.EdgeNodeComparator;
import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultGraph;
import edu.berkeley.guir.prefuse.graph.DefaultTree;
import edu.berkeley.guir.prefuse.graph.DefaultTreeNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class GraphLib {
    public static Node[] search(Graph graph, String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string3 = node.getAttribute(string);
            if (string3 == null || !string3.equals(string2)) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static Node[] getMostConnectedNodes(Graph graph) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = -1;
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            int n2 = node.getEdgeCount();
            if (n2 > n) {
                n = n2;
                arrayList.clear();
                arrayList.add(node);
                continue;
            }
            if (n2 != n) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static Tree breadthFirstTree(TreeNode treeNode) {
        Object object;
        if (treeNode == null) {
            return null;
        }
        Iterator iterator = new BreadthFirstGraphIterator(treeNode);
        while (iterator.hasNext()) {
            object = (TreeNode)iterator.next();
            object.removeAllAsChildren();
        }
        object = new HashSet();
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        linkedList.add(treeNode);
        ((HashSet)object).add(treeNode);
        treeNode.setParentEdge(null);
        while (!linkedList.isEmpty()) {
            TreeNode treeNode2 = (TreeNode)linkedList.removeFirst();
            iterator = treeNode2.getNeighbors();
            while (iterator.hasNext()) {
                TreeNode treeNode3 = (TreeNode)iterator.next();
                if (((HashSet)object).contains(treeNode3)) continue;
                treeNode2.setAsChild(treeNode3);
                linkedList.add(treeNode3);
                ((HashSet)object).add(treeNode3);
            }
        }
        return new DefaultTree(treeNode);
    }

    public static void sortTree(Tree tree, Comparator comparator) {
        TreeNode treeNode = tree.getRoot();
        GraphLib.sortHelper(treeNode, new EdgeNodeComparator(comparator));
    }

    private static void sortHelper(TreeNode treeNode, EdgeNodeComparator edgeNodeComparator) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        edgeNodeComparator.setIgnoredNode(treeNode);
        Collections.sort(arrayList, edgeNodeComparator);
        treeNode.removeAllChildren();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            treeNode.addChild(edge);
            GraphLib.sortHelper((TreeNode)edge.getAdjacentNode(treeNode), edgeNodeComparator);
        }
    }

    public static int nearestIndex(TreeNode treeNode, TreeNode treeNode2) {
        int n = 0;
        for (int i = 0; i < treeNode.getEdgeCount(); ++i) {
            TreeNode treeNode3 = (TreeNode)treeNode.getNeighbor(i);
            if (treeNode3 == treeNode2) {
                return n;
            }
            if (treeNode3.getParent() != treeNode) continue;
            ++n;
        }
        return treeNode.getChildCount();
    }

    public static int getTreeHeight(Tree tree) {
        TreeNode treeNode = tree.getRoot();
        return GraphLib.getTreeHeightHelper(treeNode, 0);
    }

    private static int getTreeHeightHelper(TreeNode treeNode, int n) {
        int n2 = n;
        if (treeNode.getChildCount() > 0) {
            Iterator iterator = treeNode.getChildren();
            while (iterator.hasNext()) {
                TreeNode treeNode2 = (TreeNode)iterator.next();
                n2 = Math.max(n2, GraphLib.getTreeHeightHelper(treeNode2, n + 1));
            }
        }
        return n2;
    }

    public static Graph getNodes(int n) {
        DefaultGraph defaultGraph = new DefaultGraph();
        for (int i = 0; i < n; ++i) {
            DefaultTreeNode defaultTreeNode = new DefaultTreeNode();
            defaultTreeNode.setAttribute("label", String.valueOf(i));
            defaultGraph.addNode(defaultTreeNode);
        }
        return defaultGraph;
    }

    public static Graph getStar(int n) {
        DefaultGraph defaultGraph = new DefaultGraph();
        DefaultTreeNode defaultTreeNode = new DefaultTreeNode();
        defaultTreeNode.setAttribute("label", "0");
        defaultGraph.addNode(defaultTreeNode);
        for (int i = 1; i <= n; ++i) {
            DefaultTreeNode defaultTreeNode2 = new DefaultTreeNode();
            defaultTreeNode2.setAttribute("label", String.valueOf(i));
            defaultGraph.addNode(defaultTreeNode2);
            DefaultEdge defaultEdge = new DefaultEdge(defaultTreeNode2, defaultTreeNode);
            defaultGraph.addEdge(defaultEdge);
        }
        return defaultGraph;
    }

    public static Graph getClique(int n) {
        int n2;
        DefaultGraph defaultGraph = new DefaultGraph();
        Node[] nodeArray = new Node[n];
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = new DefaultTreeNode();
            nodeArray[n2].setAttribute("label", String.valueOf(n2));
            defaultGraph.addNode(nodeArray[n2]);
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = n2; i < n; ++i) {
                if (n2 == i) continue;
                defaultGraph.addEdge(new DefaultEdge(nodeArray[n2], nodeArray[i]));
            }
        }
        return defaultGraph;
    }

    public static Graph getGrid(int n, int n2) {
        DefaultGraph defaultGraph = new DefaultGraph();
        Node[] nodeArray = new Node[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            nodeArray[i] = new DefaultTreeNode();
            nodeArray[i].setAttribute("label", String.valueOf(i));
            defaultGraph.addNode(nodeArray[i]);
            if (i >= n2) {
                defaultGraph.addEdge(new DefaultEdge(nodeArray[i - n2], nodeArray[i]));
            }
            if (i % n2 == 0) continue;
            defaultGraph.addEdge(new DefaultEdge(nodeArray[i - 1], nodeArray[i]));
        }
        return defaultGraph;
    }
}

