/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.io;

import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultTree;
import edu.berkeley.guir.prefuse.graph.DefaultTreeNode;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import edu.berkeley.guir.prefuse.graph.io.AbstractTreeReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TreeMLTreeReader
extends AbstractTreeReader {
    public Tree loadTree(InputStream inputStream) throws IOException {
        try {
            TreeMLHandler treeMLHandler = new TreeMLHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)treeMLHandler);
            return treeMLHandler.getTree();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    public class TreeMLHandler
    extends DefaultHandler {
        public static final String TREE = "tree";
        public static final String BRANCH = "branch";
        public static final String LEAF = "leaf";
        public static final String ATTR = "attribute";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        private Tree m_tree = null;
        private TreeNode m_root = null;
        private TreeNode m_activeNode = null;
        private boolean m_directed = false;
        private boolean inNode;
        private boolean inEdge;

        public void startDocument() {
            this.m_tree = null;
        }

        public void endDocument() {
            this.m_tree = new DefaultTree(this.m_root);
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals(BRANCH) || string3.equals(LEAF)) {
                this.m_activeNode = this.m_activeNode.getParent();
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals(BRANCH) || string3.equals(LEAF)) {
                DefaultTreeNode defaultTreeNode;
                if (this.m_activeNode == null) {
                    defaultTreeNode = new DefaultTreeNode();
                    this.m_root = defaultTreeNode;
                } else {
                    defaultTreeNode = new DefaultTreeNode();
                    this.m_activeNode.addChild(new DefaultEdge(this.m_activeNode, defaultTreeNode));
                }
                this.m_activeNode = defaultTreeNode;
            } else if (string3.equals(ATTR)) {
                this.parseAttribute(attributes);
            }
        }

        protected void parseAttribute(Attributes attributes) {
            String string = null;
            String string2 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getQName(i);
                if (string3.equals(NAME)) {
                    string = attributes.getValue(i);
                    continue;
                }
                if (!string3.equals(VALUE)) continue;
                string2 = attributes.getValue(i);
            }
            if (string == null || string2 == null) {
                System.err.println("Attribute under-specified");
                return;
            }
            this.m_activeNode.setAttribute(string, string2);
        }

        public Tree getTree() {
            return this.m_tree;
        }
    }
}

