/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.io;

import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultGraph;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.io.AbstractGraphReader;
import edu.berkeley.guir.prefuse.graph.io.GraphReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLGraphReader
extends AbstractGraphReader
implements GraphReader {
    protected Class NODE_TYPE = class$edu$berkeley$guir$prefuse$graph$DefaultNode == null ? (class$edu$berkeley$guir$prefuse$graph$DefaultNode = XMLGraphReader.class$("edu.berkeley.guir.prefuse.graph.DefaultNode")) : class$edu$berkeley$guir$prefuse$graph$DefaultNode;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$graph$DefaultNode;

    public Graph loadGraph(InputStream inputStream) throws IOException {
        try {
            XMLGraphHandler xMLGraphHandler = new XMLGraphHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)xMLGraphHandler);
            return xMLGraphHandler.getGraph();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    public Class getNodeType() {
        return this.NODE_TYPE;
    }

    public void setNodeType(Class clazz) {
        this.NODE_TYPE = clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLGraphHandler
    extends DefaultHandler {
        public static final String NODE = "node";
        public static final String EDGE = "edge";
        public static final String ATT = "att";
        public static final String ID = "id";
        public static final String LABEL = "label";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String TYPE = "type";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String LIST = "list";
        public static final String WEIGHT = "weight";
        public static final String GRAPH = "graph";
        public static final String DIRECTED = "directed";
        protected Graph m_graph = null;
        protected HashMap m_nodeMap = new HashMap();
        private Node m_activeNode = null;
        private Edge m_activeEdge = null;
        private boolean m_directed = false;
        private boolean inNode;
        private boolean inEdge;

        public boolean isDirected() {
            return this.m_directed;
        }

        public void startDocument() {
            this.m_nodeMap.clear();
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals(NODE)) {
                this.m_activeNode = null;
                this.inNode = false;
            } else if (string3.equals(EDGE)) {
                this.m_activeEdge = null;
                this.inEdge = false;
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals(GRAPH)) {
                int n = attributes.getIndex(DIRECTED);
                this.m_directed = n >= 0 && attributes.getValue(n).equals("1");
                this.m_graph = new DefaultGraph(this.m_directed);
            } else if (string3.equals(NODE)) {
                Node node;
                this.m_activeNode = node = this.parseNode(attributes);
                this.inNode = true;
            } else if (string3.equals(EDGE)) {
                Edge edge;
                this.m_activeEdge = edge = this.parseEdge(attributes);
                this.inEdge = true;
            } else if (string3.equals(ATT)) {
                this.parseAttribute(attributes);
            }
        }

        protected Node parseNode(Attributes attributes) {
            String string = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals(ID)) continue;
                string = attributes.getValue(i);
            }
            if (string == null) {
                System.err.println("Node missing id");
                return null;
            }
            Node node = null;
            try {
                node = (Node)XMLGraphReader.this.NODE_TYPE.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            node.setAttribute(ID, string);
            this.m_nodeMap.put(string, node);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string2 = attributes.getQName(i);
                if (string2.equals(ID)) continue;
                node.setAttribute(string2, attributes.getValue(i));
            }
            this.m_graph.addNode(node);
            return node;
        }

        protected Edge parseEdge(Attributes attributes) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getQName(i);
                if (string5.equals(SOURCE)) {
                    string = attributes.getValue(i);
                    continue;
                }
                if (string5.equals(TARGET)) {
                    string2 = attributes.getValue(i);
                    continue;
                }
                if (string5.equals(LABEL)) {
                    string3 = attributes.getValue(i);
                    continue;
                }
                if (!string5.equals(WEIGHT)) continue;
                string4 = attributes.getValue(i);
            }
            Node node = (Node)this.m_nodeMap.get(string);
            Node node2 = (Node)this.m_nodeMap.get(string2);
            if (string == null || string2 == null || node == null || node2 == null) {
                System.err.println("Edge missing source or target");
                return null;
            }
            DefaultEdge defaultEdge = new DefaultEdge(node, node2, this.m_directed);
            if (string3 != null) {
                defaultEdge.setAttribute(LABEL, string3);
            }
            if (string4 != null) {
                defaultEdge.setAttribute(WEIGHT, string4);
            }
            this.m_graph.addEdge(defaultEdge);
            return defaultEdge;
        }

        protected void parseAttribute(Attributes attributes) {
            String string = null;
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                if (string4.equals(TYPE)) {
                    string = attributes.getValue(i);
                    continue;
                }
                if (string4.equals(NAME)) {
                    string2 = attributes.getValue(i);
                    continue;
                }
                if (!string4.equals(VALUE)) continue;
                string3 = attributes.getValue(i);
            }
            if (string != null && string.equals(LIST) || string2 == null || string3 == null) {
                System.err.println("Attribute under-specified");
                return;
            }
            if (this.inNode) {
                this.m_activeNode.setAttribute(string2, string3);
            } else if (this.inEdge) {
                this.m_activeEdge.setAttribute(string2, string3);
            }
        }

        public Graph getGraph() {
            return this.m_graph;
        }
    }
}

