/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.TextItemRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;

public class MultiLineTextItemRenderer
extends TextItemRenderer {
    public static final int DEFAULT_MAXLINES = 1;
    protected ArrayList m_attrList = new ArrayList();

    public void addTextAttribute(String string) {
        this.addTextAttribute(string, 1, null);
    }

    public void addTextAttribute(String string, int n) {
        this.m_attrList.add(new TextEntry(string, n, null));
    }

    public void addTextAttribute(String string, int n, Font font) {
        this.m_attrList.add(new TextEntry(string, n, font));
    }

    protected String getText(VisualItem visualItem) {
        throw new UnsupportedOperationException();
    }

    protected String getText(VisualItem visualItem, int n) {
        String string = ((TextEntry)this.m_attrList.get((int)n)).name;
        return visualItem.getAttribute(string);
    }

    public int getNumEntries() {
        return this.m_attrList.size();
    }

    protected int getMaxLines(int n) {
        return ((TextEntry)this.m_attrList.get((int)n)).maxlines;
    }

    protected Font getFont(VisualItem visualItem, int n) {
        Font font = ((TextEntry)this.m_attrList.get((int)n)).font;
        if (font == null) {
            font = visualItem.getFont();
        }
        if (font == null) {
            font = this.m_font;
        }
        return font;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        int n = 2 * this.m_horizBorder;
        int n2 = 2 * this.m_vertBorder;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            Font font = this.getFont(visualItem, i);
            FontMetrics fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(font);
            String string = this.getText(visualItem, i);
            int n3 = this.getMaxLines(i);
            if (string == null) continue;
            n2 += fontMetrics.getHeight();
            n = Math.max(n, fontMetrics.stringWidth(string) + 2 * this.m_horizBorder);
        }
        MultiLineTextItemRenderer.getAlignedPoint(this.m_tmpPoint, visualItem, n, n2, this.m_xAlign, this.m_yAlign);
        this.m_textBox.setFrame(this.m_tmpPoint.getX(), this.m_tmpPoint.getY(), n, n2);
        return this.m_textBox;
    }

    public Rectangle getEntryBounds(VisualItem visualItem, int n) {
        int n2 = this.m_vertBorder;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2 * this.m_horizBorder;
        int n6 = 2 * this.m_vertBorder;
        for (int i = 0; i <= n; ++i) {
            Font font = this.getFont(visualItem, i);
            FontMetrics fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(font);
            String string = this.getText(visualItem, i);
            int n7 = this.getMaxLines(i);
            if (string == null) continue;
            n6 += fontMetrics.getHeight();
            n5 = Math.max(n5, fontMetrics.stringWidth(string) + 2 * this.m_horizBorder);
            if (i < n) {
                n2 += fontMetrics.getHeight();
                continue;
            }
            if (i != n) continue;
            n3 = fontMetrics.stringWidth(string) + 2 * this.m_horizBorder;
            n4 = fontMetrics.getHeight();
        }
        MultiLineTextItemRenderer.getAlignedPoint(this.m_tmpPoint, visualItem, n5, n6, this.m_xAlign, this.m_yAlign);
        this.m_textBox.setFrame(this.m_tmpPoint.getX(), this.m_tmpPoint.getY() + (double)n2, n3, n4);
        return this.m_textBox.getBounds();
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Paint paint = visualItem.getFillColor();
        Paint paint2 = visualItem.getColor();
        Shape shape = this.getShape(visualItem);
        if (shape != null) {
            switch (this.getRenderType(visualItem)) {
                case 1: {
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(shape);
                    break;
                }
                case 2: {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(shape);
                    break;
                }
                case 3: {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(shape);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(shape);
                }
            }
            Rectangle rectangle = shape.getBounds();
            int n = rectangle.y + this.m_vertBorder;
            for (int i = 0; i < this.getNumEntries(); ++i) {
                Font font = this.getFont(visualItem, i);
                FontMetrics fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(font);
                String string = this.getText(visualItem, i);
                int n2 = this.getMaxLines(i);
                if (string == null) continue;
                Color color = (Color)visualItem.getVizAttribute("overlay_" + i);
                if (color != null) {
                    graphics2D.setColor(color);
                    Rectangle rectangle2 = new Rectangle(rectangle.x + this.m_horizBorder, n, fontMetrics.stringWidth(string), fontMetrics.getHeight());
                    graphics2D.fill(rectangle2);
                }
                graphics2D.setPaint(paint2);
                graphics2D.setFont(font);
                graphics2D.drawString(string, rectangle.x + this.m_horizBorder, n + fontMetrics.getAscent());
                n += fontMetrics.getHeight();
            }
        }
    }

    protected class TextEntry {
        String name;
        int maxlines;
        Font font;

        public TextEntry(String string, int n, Font font) {
            this.name = string;
            this.maxlines = n;
            this.font = font;
        }
    }
}

