/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.Renderer;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class ShapeRenderer
implements Renderer {
    public static final int RENDER_TYPE_NONE = 0;
    public static final int RENDER_TYPE_DRAW = 1;
    public static final int RENDER_TYPE_FILL = 2;
    public static final int RENDER_TYPE_DRAW_AND_FILL = 3;
    private int m_renderType = 3;
    protected AffineTransform m_transform = new AffineTransform();

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape != null) {
            this.drawShape(graphics2D, visualItem, shape);
        }
    }

    protected void drawShape(Graphics2D graphics2D, VisualItem visualItem, Shape shape) {
        Paint paint = visualItem.getColor();
        Paint paint2 = visualItem.getFillColor();
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = this.getStroke(visualItem);
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        switch (this.getRenderType(visualItem)) {
            case 1: {
                graphics2D.setPaint(paint);
                graphics2D.draw(shape);
                break;
            }
            case 2: {
                graphics2D.setPaint(paint2);
                graphics2D.fill(shape);
                break;
            }
            case 3: {
                graphics2D.setPaint(paint2);
                graphics2D.fill(shape);
                graphics2D.setPaint(paint);
                graphics2D.draw(shape);
            }
        }
        graphics2D.setStroke(stroke);
    }

    public Shape getShape(VisualItem visualItem) {
        AffineTransform affineTransform = this.getTransform(visualItem);
        Shape shape = this.getRawShape(visualItem);
        return affineTransform == null ? shape : affineTransform.createTransformedShape(shape);
    }

    protected abstract Shape getRawShape(VisualItem var1);

    protected BasicStroke getStroke(VisualItem visualItem) {
        return null;
    }

    protected AffineTransform getTransform(VisualItem visualItem) {
        return null;
    }

    public int getRenderType(VisualItem visualItem) {
        return this.m_renderType;
    }

    public void setRenderType(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Unrecognized render type.");
        }
        this.m_renderType = n;
    }

    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        return shape != null ? shape.contains(point2D) : false;
    }

    public Rectangle2D getBoundsRef(VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return new Rectangle(-1, -1, 0, 0);
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        BasicStroke basicStroke = this.getStroke(visualItem);
        if (basicStroke != null) {
            double d = basicStroke.getLineWidth();
            double d2 = d / 2.0;
            rectangle2D.setFrame(rectangle2D.getX() - d2, rectangle2D.getY() - d2, rectangle2D.getWidth() + d, rectangle2D.getHeight() + d);
        }
        return rectangle2D;
    }
}

