/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import edu.berkeley.guir.prefuse.util.ArrayLib;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GeometryLib {
    public static final int NO_INTERSECTION = 0;
    public static final int COINCIDENT = -1;
    public static final int PARALLEL = -2;

    public static int intersectLineLine(Line2D line2D, Line2D line2D2, Point2D point2D) {
        double d = line2D.getX1();
        double d2 = line2D.getY1();
        double d3 = line2D.getX2();
        double d4 = line2D.getY2();
        double d5 = line2D2.getX1();
        double d6 = line2D2.getY1();
        double d7 = line2D2.getX2();
        double d8 = line2D2.getY2();
        return GeometryLib.intersectLineLine(d, d2, d3, d4, d5, d6, d7, d8, point2D);
    }

    public static int intersectLineLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Point2D point2D) {
        double d9 = (d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5);
        double d10 = (d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5);
        double d11 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        if (d11 != 0.0) {
            double d12 = d9 / d11;
            double d13 = d10 / d11;
            if (0.0 <= d12 && d12 <= 1.0 && 0.0 <= d13 && d13 <= 1.0) {
                point2D.setLocation(d + d12 * (d3 - d), d2 + d12 * (d4 - d2));
                return 1;
            }
            return 0;
        }
        return d9 == 0.0 || d10 == 0.0 ? -1 : -2;
    }

    public static int intersectLineRectangle(Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D, Point2D[] point2DArray) {
        int n;
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        double d5 = rectangle2D.getMaxX();
        double d6 = rectangle2D.getMaxY();
        double d7 = rectangle2D.getMinX();
        double d8 = rectangle2D.getMinY();
        if (point2DArray[0] == null) {
            point2DArray[0] = new Point2D.Double();
        }
        if (point2DArray[1] == null) {
            point2DArray[1] = new Point2D.Double();
        }
        if (GeometryLib.intersectLineLine(d7, d8, d5, d8, d, d2, d3, d4, point2DArray[n = 0]) > 0) {
            ++n;
        }
        if (GeometryLib.intersectLineLine(d5, d8, d5, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GeometryLib.intersectLineLine(d5, d6, d7, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GeometryLib.intersectLineLine(d7, d6, d7, d8, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        return n;
    }

    public static int intersectLineRectangle(Line2D line2D, Rectangle2D rectangle2D, Point2D[] point2DArray) {
        int n;
        double d = line2D.getX1();
        double d2 = line2D.getY1();
        double d3 = line2D.getX2();
        double d4 = line2D.getY2();
        double d5 = rectangle2D.getMaxX();
        double d6 = rectangle2D.getMaxY();
        double d7 = rectangle2D.getMinX();
        double d8 = rectangle2D.getMinY();
        if (point2DArray[0] == null) {
            point2DArray[0] = new Point2D.Double();
        }
        if (point2DArray[1] == null) {
            point2DArray[1] = new Point2D.Double();
        }
        if (GeometryLib.intersectLineLine(d7, d8, d5, d8, d, d2, d3, d4, point2DArray[n = 0]) > 0) {
            ++n;
        }
        if (GeometryLib.intersectLineLine(d5, d8, d5, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GeometryLib.intersectLineLine(d5, d6, d7, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GeometryLib.intersectLineLine(d7, d6, d7, d8, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        return n;
    }

    public static double[] convexHull(double[] dArray, int n) {
        int n2;
        if (n < 6) {
            throw new IllegalArgumentException("Input must have at least 3 points");
        }
        int n3 = 0;
        for (int i = 2; i < n; i += 2) {
            if (dArray[i + 1] < dArray[n3 + 1]) {
                n3 = i;
                continue;
            }
            if (dArray[i + 1] != dArray[n3 + 1]) continue;
            n3 = dArray[i] < dArray[n3] ? i : n3;
        }
        float[] fArray = new float[n / 2 - 1];
        int[] nArray = new int[n / 2 - 1];
        int n4 = 0;
        for (int i = 0; i < n; i += 2) {
            if (i == n3) continue;
            fArray[n4] = (float)Math.atan2(dArray[i + 1] - dArray[n3 + 1], dArray[i] - dArray[n3]);
            nArray[n4] = i;
            ++n4;
        }
        ArrayLib.sort(fArray, nArray);
        float f = fArray[0];
        n4 = 0;
        for (n2 = 1; n2 < fArray.length; ++n2) {
            if (f == fArray[n2]) {
                double d;
                double d2 = Math.sqrt(dArray[n2] * dArray[n2] + dArray[n2 + 1] * dArray[n2 + 1]);
                if (d2 >= (d = Math.sqrt(dArray[n4] * dArray[n4] + dArray[n4 + 1] * dArray[n4 + 1]))) {
                    nArray[n2] = -1;
                    continue;
                }
                nArray[n4] = -1;
                f = fArray[n2];
                n4 = n2;
                continue;
            }
            f = fArray[n2];
            n4 = n2;
        }
        n2 = 0;
        int[] nArray2 = new int[n / 2];
        nArray2[n2++] = n3;
        int n5 = 0;
        int n6 = 0;
        while (n6 < 2) {
            if (nArray[n5] != -1) {
                nArray2[n2++] = nArray[n5];
                ++n6;
            }
            ++n5;
        }
        while (n5 < nArray.length) {
            if (nArray[n5] != -1) {
                while (GeometryLib.isNonLeft(n3, nArray2[n2 - 2], nArray2[n2 - 1], nArray[n5], dArray)) {
                    --n2;
                }
                nArray2[n2++] = nArray[n5];
            }
            ++n5;
        }
        double[] dArray2 = new double[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            dArray2[2 * i] = dArray[nArray2[i]];
            dArray2[2 * i + 1] = dArray[nArray2[i] + 1];
        }
        return dArray2;
    }

    private static boolean isNonLeft(int n, int n2, int n3, int n4, double[] dArray) {
        double d;
        double d2 = Math.sqrt(Math.pow(dArray[n3 + 1] - dArray[n2 + 1], 2.0) + Math.pow(dArray[n3] - dArray[n2], 2.0));
        double d3 = Math.sqrt(Math.pow(dArray[n4 + 1] - dArray[n3 + 1], 2.0) + Math.pow(dArray[n4] - dArray[n3], 2.0));
        double d4 = Math.sqrt(Math.pow(dArray[n4 + 1] - dArray[n + 1], 2.0) + Math.pow(dArray[n4] - dArray[n], 2.0));
        double d5 = Math.sqrt(Math.pow(dArray[n2 + 1] - dArray[n + 1], 2.0) + Math.pow(dArray[n2] - dArray[n], 2.0));
        double d6 = Math.sqrt(Math.pow(dArray[n3 + 1] - dArray[n + 1], 2.0) + Math.pow(dArray[n3] - dArray[n], 2.0));
        double d7 = Math.acos((d3 * d3 + d6 * d6 - d4 * d4) / (2.0 * d3 * d6));
        double d8 = Math.PI - d7 - (d = Math.acos((d6 * d6 + d2 * d2 - d5 * d5) / (2.0 * d6 * d2)));
        return d8 <= 0.0;
    }

    public static double[] centroid(double[] dArray, int n) {
        double[] dArray2 = new double[]{0.0, 0.0};
        for (int i = 0; i < n; i += 2) {
            dArray2[0] = dArray2[0] + dArray[i];
            dArray2[1] = dArray2[1] + dArray[i + 1];
        }
        dArray2[0] = dArray2[0] / (double)(n / 2);
        dArray2[1] = dArray2[1] / (double)(n / 2);
        return dArray2;
    }

    public static void growPolygon(double[] dArray, int n, double d) {
        double[] dArray2 = GeometryLib.centroid(dArray, n);
        for (int i = 0; i < n; i += 2) {
            double d2 = dArray[i] - dArray2[0];
            double d3 = dArray[i + 1] - dArray2[1];
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            int n2 = i;
            dArray[n2] = dArray[n2] + d * d2 / d4;
            int n3 = i + 1;
            dArray[n3] = dArray[n3] + d * d3 / d4;
        }
    }

    public static GeneralPath cardinalSpline(float[] fArray, float f, boolean bl) {
        float f2;
        float f3;
        int n;
        float f4;
        float f5;
        if (fArray.length < 6) {
            throw new IllegalArgumentException("To create spline requires at least 3 points");
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0], fArray[1]);
        if (bl) {
            f5 = fArray[2] - fArray[fArray.length - 2];
            f4 = fArray[3] - fArray[fArray.length - 1];
        } else {
            f5 = fArray[4] - fArray[0];
            f4 = fArray[5] - fArray[1];
        }
        for (n = 2; n < fArray.length - 2; n += 2) {
            f3 = f5;
            f2 = f4;
            f5 = fArray[n + 2] - fArray[n - 2];
            f4 = fArray[n + 3] - fArray[n - 1];
            generalPath.curveTo(fArray[n - 2] + f * f3, fArray[n - 1] + f * f2, fArray[n] - f * f5, fArray[n + 1] - f * f4, fArray[n], fArray[n + 1]);
        }
        if (bl) {
            f3 = f5;
            f2 = f4;
            f5 = fArray[0] - fArray[n - 2];
            f4 = fArray[1] - fArray[n - 1];
            generalPath.curveTo(fArray[n - 2] + f * f3, fArray[n - 1] + f * f2, fArray[n] - f * f5, fArray[n + 1] - f * f4, fArray[n], fArray[n + 1]);
            f3 = f5;
            f2 = f4;
            f5 = fArray[2] - fArray[fArray.length - 2];
            f4 = fArray[3] - fArray[fArray.length - 1];
            generalPath.curveTo(fArray[fArray.length - 2] + f * f3, fArray[fArray.length - 1] + f * f2, fArray[0] - f * f5, fArray[1] - f * f4, fArray[0], fArray[1]);
            generalPath.closePath();
        } else {
            generalPath.curveTo(fArray[n - 2] + f * f5, fArray[n - 1] + f * f4, fArray[n] - f * f5, fArray[n + 1] - f * f4, fArray[n], fArray[n + 1]);
        }
        return generalPath;
    }
}

