/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util.display;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Clip {
    private double[] clip = new double[8];
    private double[] tmp = new double[8];

    public void setClip(double d, double d2, double d3, double d4) {
        this.clip[0] = d;
        this.clip[1] = d2;
        this.clip[2] = d;
        this.clip[3] = d4;
        this.clip[4] = d3;
        this.clip[5] = d2;
        this.clip[6] = d3;
        this.clip[7] = d4;
    }

    public void setClip(Clip clip) {
        System.arraycopy(clip.clip, 0, this.clip, 0, 4);
    }

    public void setClip(Rectangle2D rectangle2D) {
        this.clip[0] = rectangle2D.getX();
        this.clip[1] = rectangle2D.getY();
        this.clip[6] = this.clip[0] + rectangle2D.getWidth();
        this.clip[7] = this.clip[1] + rectangle2D.getHeight();
        this.clip[2] = this.clip[0];
        this.clip[3] = this.clip[7];
        this.clip[4] = this.clip[6];
        this.clip[5] = this.clip[1];
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.clip, 0, this.tmp, 0, 4);
        double[] dArray = this.tmp;
        this.tmp = this.clip;
        this.clip = dArray;
        double d = this.clip[0];
        double d2 = this.clip[1];
        double d3 = this.clip[6];
        double d4 = this.clip[7];
        for (int i = 0; i < 7; i += 2) {
            if (this.clip[i] < d) {
                d = this.clip[i];
            }
            if (this.clip[i] > d3) {
                d3 = this.clip[i];
            }
            if (this.clip[i + 1] < d2) {
                d2 = this.clip[i + 1];
            }
            if (!(this.clip[i + 1] > d4)) continue;
            d4 = this.clip[i + 1];
        }
        this.clip[0] = d;
        this.clip[1] = d2;
        this.clip[2] = d;
        this.clip[3] = d4;
        this.clip[4] = d3;
        this.clip[5] = d2;
        this.clip[6] = d3;
        this.clip[7] = d4;
    }

    public void limit(double d, double d2, double d3, double d4) {
        this.clip[0] = Math.max(this.clip[0], d);
        this.clip[1] = Math.max(this.clip[1], d2);
        this.clip[6] = Math.min(this.clip[6], d3);
        this.clip[7] = Math.min(this.clip[7], d4);
        this.clip[2] = this.clip[0];
        this.clip[3] = this.clip[7];
        this.clip[4] = this.clip[6];
        this.clip[5] = this.clip[1];
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        double d = this.clip[6] - this.clip[0];
        double d2 = this.clip[7] - this.clip[1];
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (d3 < 0.0 || d4 < 0.0 || d < 0.0 || d2 < 0.0) {
            return false;
        }
        double d5 = this.clip[0];
        double d6 = this.clip[1];
        double d7 = rectangle2D.getX();
        double d8 = rectangle2D.getY();
        return ((d3 += d7) < d7 || d3 > d5) && ((d4 += d8) < d8 || d4 > d6) && ((d += d5) < d5 || d > d7) && ((d2 += d6) < d6 || d2 > d8);
    }

    public void union(Clip clip) {
        this.clip[0] = Math.min(this.clip[0], clip.clip[0]);
        this.clip[1] = Math.min(this.clip[1], clip.clip[1]);
        this.clip[2] = Math.max(this.clip[6], clip.clip[6]);
        this.clip[3] = Math.max(this.clip[7], clip.clip[7]);
    }

    public void union(Rectangle2D rectangle2D) {
        this.clip[0] = Math.min(this.clip[0], rectangle2D.getX() - 1.0);
        this.clip[1] = Math.min(this.clip[1], rectangle2D.getY() - 1.0);
        this.clip[2] = Math.max(this.clip[6], rectangle2D.getX() + rectangle2D.getWidth() + 1.0);
        this.clip[3] = Math.max(this.clip[7], rectangle2D.getX() + rectangle2D.getHeight() + 1.0);
    }

    public double getX() {
        return this.clip[0];
    }

    public double getY() {
        return this.clip[1];
    }

    public double getWidth() {
        return this.clip[6] - this.clip[0];
    }

    public double getHeight() {
        return this.clip[7] - this.clip[1];
    }
}

