/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util.display;

import edu.berkeley.guir.prefuse.Display;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ToolTipManager
implements MouseMotionListener {
    private Display m_display;
    private JComponent m_tooltip;
    private ToolTipTimer m_toolTipTimer;
    private boolean m_toolTipsEnabled;
    private long m_toolTipDelay = 2000L;

    public ToolTipManager(Display display, JComponent jComponent) {
        this.m_display = display;
        this.m_tooltip = jComponent;
        this.m_tooltip.setVisible(false);
        this.m_toolTipTimer = new ToolTipTimer();
        this.m_toolTipsEnabled = true;
        new Thread(this.m_toolTipTimer).start();
    }

    public ToolTipManager(Display display) {
        this.m_display = display;
        this.m_tooltip = new DefaultToolTipper();
        this.m_tooltip.setVisible(false);
        this.m_toolTipTimer = new ToolTipTimer();
        this.m_toolTipsEnabled = true;
        new Thread(this.m_toolTipTimer).start();
    }

    public void showToolTip(int n, int n2) {
        this.m_toolTipTimer.show(n, n2);
    }

    public void hideToolTip() {
        this.m_toolTipTimer.hide();
    }

    public void setToolTipComponent(JComponent jComponent) {
        this.m_display.remove(this.m_tooltip);
        this.m_tooltip = jComponent;
        this.m_display.add((Component)this.m_tooltip, 0);
    }

    public JComponent getToolTipComponent() {
        return this.m_tooltip;
    }

    public long getToolTipDelay() {
        return this.m_toolTipDelay;
    }

    public void setToolTipDelay(long l) {
        this.m_toolTipDelay = l;
    }

    public boolean isToolTipsEnabled() {
        return this.m_toolTipsEnabled;
    }

    public void setToolTipsEnabled(boolean bl) {
        this.m_toolTipsEnabled = bl;
    }

    public String getToolTipText() {
        if (this.m_tooltip instanceof DefaultToolTipper) {
            return ((DefaultToolTipper)this.m_tooltip).getText();
        }
        throw new IllegalStateException();
    }

    public void setToolTipText(String string) {
        if (!(this.m_tooltip instanceof DefaultToolTipper)) {
            throw new IllegalStateException();
        }
        ((DefaultToolTipper)this.m_tooltip).setText(string);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moveEvent(mouseEvent);
    }

    private void moveEvent(MouseEvent mouseEvent) {
        if (this.getToolTipText() != null) {
            this.showToolTip(mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.hideToolTip();
        }
    }

    public class DefaultToolTipper
    extends JComponent {
        private String text = null;

        public DefaultToolTipper() {
            this.setBackground(new Color(255, 255, 225));
            this.setForeground(Color.BLACK);
        }

        public Dimension getPreferredSize() {
            if (this.text == null) {
                return new Dimension(0, 0);
            }
            Graphics graphics = ToolTipManager.this.m_display.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getText();
            int n = 8;
            if (string != null) {
                n += fontMetrics.stringWidth(string);
            }
            int n2 = fontMetrics.getHeight();
            return new Dimension(n, n2);
        }

        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.text != null) {
                graphics.drawString(this.text, 4, fontMetrics.getAscent());
            }
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }
    }

    public class ToolTipTimer
    implements Runnable {
        int DEFAULT_X_OFFSET = 15;
        int DEFAULT_Y_OFFSET = 10;
        boolean visible = false;
        boolean show = false;
        boolean squit = true;
        boolean hquit = true;
        boolean hide = false;
        int x;
        int y;

        public synchronized void show(int n, int n2) {
            this.squit = false;
            this.show = true;
            this.hide = false;
            this.x = n;
            this.y = n2;
            this.notifyAll();
        }

        public synchronized void hide() {
            this.squit = true;
            this.hide = true;
            this.show = false;
            this.notifyAll();
        }

        public void run() {
            ToolTipTimer toolTipTimer = this;
            synchronized (toolTipTimer) {
                while (true) {
                    if (!this.visible && this.show) {
                        if (ToolTipManager.this.m_toolTipDelay >= 10L) {
                            try {
                                this.wait(ToolTipManager.this.m_toolTipDelay);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!this.squit) {
                            this.paint();
                            this.visible = true;
                            this.show = false;
                        }
                    } else if (this.visible && this.show) {
                        this.paint();
                        this.show = false;
                    } else if (this.visible && this.hide) {
                        try {
                            this.wait(250L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.hide) {
                            this.unpaint();
                            this.visible = false;
                            this.hide = false;
                        }
                    } else if (this.hide) {
                        this.hide = false;
                    }
                    if (this.hide || this.show) continue;
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.squit = false;
                }
            }
        }

        public void paint() {
            ToolTipManager.this.m_display.repaintImmediate();
            Dimension dimension = ToolTipManager.this.m_tooltip.getPreferredSize();
            Graphics2D graphics2D = (Graphics2D)ToolTipManager.this.m_display.getGraphics();
            int n = this.x + this.DEFAULT_X_OFFSET;
            int n2 = this.y + this.DEFAULT_Y_OFFSET;
            if ((double)n + dimension.getWidth() > (double)ToolTipManager.this.m_display.getWidth() && dimension.getWidth() < (double)ToolTipManager.this.m_display.getWidth()) {
                n = this.x - (int)dimension.getWidth() - this.DEFAULT_X_OFFSET;
            }
            if ((double)n2 + dimension.getHeight() > (double)ToolTipManager.this.m_display.getHeight() && dimension.getHeight() < (double)ToolTipManager.this.m_display.getHeight()) {
                n2 = this.y - (int)dimension.getHeight() - this.DEFAULT_Y_OFFSET;
            }
            SwingUtilities.paintComponent(graphics2D, ToolTipManager.this.m_tooltip, ToolTipManager.this.m_display, n, n2, dimension.width, dimension.height);
        }

        public void unpaint() {
            ToolTipManager.this.m_display.repaintImmediate();
        }
    }
}

