/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.FocusManager;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class FocusControl
extends ControlAdapter {
    private Object focusSetKey = "default";
    protected int ccount;
    protected Class[] itemTypes = new Class[]{class$edu$berkeley$guir$prefuse$NodeItem == null ? (class$edu$berkeley$guir$prefuse$NodeItem = FocusControl.class$("edu.berkeley.guir.prefuse.NodeItem")) : class$edu$berkeley$guir$prefuse$NodeItem};
    protected Activity activity = null;
    protected Entity curFocus = null;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$NodeItem;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$VisualItem;

    public FocusControl() {
        this(1);
    }

    public FocusControl(Activity activity) {
        this(1);
        this.activity = activity;
    }

    public FocusControl(int n) {
        this.ccount = n;
    }

    public FocusControl(int n, Activity activity) {
        this.ccount = n;
        this.activity = activity;
    }

    public FocusControl(int n, Class[] classArray) {
        this.ccount = n;
        this.setFocusItemTypes(classArray);
    }

    public FocusControl(int n, Object object) {
        this.ccount = n;
        this.focusSetKey = object;
    }

    public FocusControl(int n, Activity activity, Object object) {
        this.ccount = n;
        this.activity = activity;
        this.focusSetKey = object;
    }

    public FocusControl(int n, Object object, Class[] classArray) {
        this.ccount = n;
        this.focusSetKey = object;
        this.setFocusItemTypes(classArray);
    }

    public void setFocusItemTypes(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (this.isVisualItem(classArray[i])) continue;
            throw new IllegalArgumentException("All types must be of type VisualItem");
        }
        this.itemTypes = (Class[])classArray.clone();
    }

    protected boolean isVisualItem(Class clazz) {
        while (clazz != null && !(class$edu$berkeley$guir$prefuse$VisualItem == null ? FocusControl.class$("edu.berkeley.guir.prefuse.VisualItem") : class$edu$berkeley$guir$prefuse$VisualItem).equals(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return clazz != null;
    }

    protected boolean isAllowedType(VisualItem visualItem) {
        for (int i = 0; i < this.itemTypes.length; ++i) {
            if (!this.itemTypes[i].isInstance(visualItem)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.isAllowedType(visualItem)) {
            Display display = (Display)mouseEvent.getSource();
            display.setCursor(Cursor.getPredefinedCursor(12));
            if (this.ccount == 0) {
                ItemRegistry itemRegistry;
                this.curFocus = visualItem.getEntity();
                ItemRegistry itemRegistry2 = itemRegistry = visualItem.getItemRegistry();
                synchronized (itemRegistry2) {
                    FocusManager focusManager = itemRegistry.getFocusManager();
                    FocusSet focusSet = focusManager.getFocusSet(this.focusSetKey);
                    focusSet.set(visualItem.getEntity());
                    itemRegistry.touch(visualItem.getItemClass());
                }
                this.runActivity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.isAllowedType(visualItem)) {
            Display display = (Display)mouseEvent.getSource();
            display.setCursor(Cursor.getDefaultCursor());
            if (this.ccount == 0) {
                this.curFocus = null;
                ItemRegistry itemRegistry = visualItem.getItemRegistry();
                if (itemRegistry != null) {
                    ItemRegistry itemRegistry2 = itemRegistry;
                    synchronized (itemRegistry2) {
                        FocusManager focusManager = itemRegistry.getFocusManager();
                        FocusSet focusSet = focusManager.getFocusSet(this.focusSetKey);
                        focusSet.remove(visualItem.getEntity());
                        itemRegistry.touch(visualItem.getItemClass());
                    }
                }
                this.runActivity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        Entity entity;
        if (this.isAllowedType(visualItem) && this.ccount > 0 && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == this.ccount && (entity = visualItem.getEntity()) != this.curFocus) {
            ItemRegistry itemRegistry;
            ItemRegistry itemRegistry2 = itemRegistry = visualItem.getItemRegistry();
            synchronized (itemRegistry2) {
                FocusManager focusManager = itemRegistry.getFocusManager();
                FocusSet focusSet = focusManager.getFocusSet(this.focusSetKey);
                boolean bl = mouseEvent.isControlDown();
                if (!bl) {
                    this.curFocus = entity;
                    focusSet.set(entity);
                } else if (focusSet.contains(entity)) {
                    focusSet.remove(entity);
                } else {
                    focusSet.add(entity);
                }
                itemRegistry.touch(visualItem.getItemClass());
            }
            this.runActivity();
        }
    }

    private void runActivity() {
        if (this.activity != null) {
            this.activity.runNow();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

