/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.SwingUtilities;

public class RotationControl
extends ControlAdapter {
    private int xLast;
    private int yLast;
    private boolean repaint = true;

    public RotationControl() {
        this(true);
    }

    public RotationControl(boolean bl) {
        this.repaint = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Display display = (Display)mouseEvent.getComponent();
            display.setCursor(Cursor.getPredefinedCursor(8));
            this.xLast = mouseEvent.getX();
            this.yLast = mouseEvent.getY();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Display display = (Display)mouseEvent.getComponent();
            double d = display.getScale();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.xLast;
            int n4 = n2 - this.yLast;
            double d2 = (double)n3 / 40.0;
            AffineTransform affineTransform = display.getTransform();
            affineTransform.rotate(d2);
            try {
                display.setTransform(affineTransform);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.yLast = n2;
            this.xLast = n;
            if (this.repaint) {
                display.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

