/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ZoomControl
extends ControlAdapter {
    private int yLast;
    private Point2D down = new Point2D.Float();
    private boolean repaint = true;
    private double minScale = 1.0E-4;
    private double maxScale = 75.0;

    public ZoomControl() {
        this(true);
    }

    public ZoomControl(boolean bl) {
        this.repaint = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Display display = (Display)mouseEvent.getComponent();
            if (display.isTranformInProgress()) {
                this.yLast = -1;
                return;
            }
            display.setCursor(Cursor.getPredefinedCursor(8));
            display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
            this.yLast = mouseEvent.getY();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Display display = (Display)mouseEvent.getComponent();
            if (display.isTranformInProgress() || this.yLast == -1) {
                this.yLast = -1;
                return;
            }
            double d = display.getScale();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n2 - this.yLast;
            double d2 = 1.0 + (double)n3 / 100.0;
            double d3 = d * d2;
            if (d3 < this.minScale) {
                d2 = this.minScale / d;
                display.setCursor(Cursor.getPredefinedCursor(3));
            } else if (d3 > this.maxScale) {
                d2 = this.maxScale / d;
                display.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                display.setCursor(Cursor.getPredefinedCursor(8));
            }
            display.zoomAbs(this.down, d2);
            this.yLast = n2;
            if (this.repaint) {
                display.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double d) {
        this.maxScale = d;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double d) {
        this.minScale = d;
    }
}

