/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.distortion;

import edu.berkeley.guir.prefusex.distortion.Distortion;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BifocalDistortion
extends Distortion {
    private double rx;
    private double ry;
    private double mx;
    private double my;
    private boolean bx;
    private boolean by;

    public BifocalDistortion() {
        this(0.1, 3.0);
    }

    public BifocalDistortion(double d, double d2) {
        this(d, d2, d, d2);
    }

    public BifocalDistortion(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, false);
    }

    public BifocalDistortion(double d, double d2, double d3, double d4, boolean bl) {
        super(bl);
        this.rx = d;
        this.mx = d2;
        this.ry = d3;
        this.my = d4;
        this.bx = this.rx != 0.0 && this.mx != 1.0;
        this.by = this.ry != 0.0 && this.my != 1.0;
    }

    protected void transformPoint(Point2D point2D, Point2D point2D2, Point2D point2D3, Rectangle2D rectangle2D) {
        double d = point2D.getX();
        if (this.bx) {
            d = this.bifocal(d, point2D3.getX(), this.rx, this.mx, rectangle2D.getMinX(), rectangle2D.getMaxX());
        }
        double d2 = point2D.getY();
        if (this.by) {
            d2 = this.bifocal(point2D.getY(), point2D3.getY(), this.ry, this.my, rectangle2D.getMinY(), rectangle2D.getMaxY());
        }
        point2D2.setLocation(d, d2);
    }

    protected double transformSize(Rectangle2D rectangle2D, Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl = false;
        boolean bl2 = false;
        if (this.bx) {
            d5 = rectangle2D.getCenterX();
            d4 = point2D2.getX();
            d3 = rectangle2D2.getMinX();
            d2 = rectangle2D2.getMaxX();
            double d6 = d = d5 < d4 ? d4 - d3 : d2 - d4;
            if (d == 0.0) {
                d = d2 - d3;
            }
            if (Math.abs(d5 - d4) <= this.rx * d) {
                bl = true;
            }
        }
        if (this.by) {
            d5 = rectangle2D.getCenterY();
            d4 = point2D2.getY();
            d3 = rectangle2D2.getMinY();
            d2 = rectangle2D2.getMaxY();
            double d7 = d = d5 < d4 ? d4 - d3 : d2 - d4;
            if (d == 0.0) {
                d = d2 - d3;
            }
            if (Math.abs(d5 - d4) <= this.ry * d) {
                bl2 = true;
            }
        }
        if (bl && !this.by) {
            return this.mx;
        }
        if (bl2 && !this.bx) {
            return this.my;
        }
        if (bl && bl2) {
            return Math.min(this.mx, this.my);
        }
        return Math.min((1.0 - this.rx * this.mx) / (1.0 - this.rx), (1.0 - this.ry * this.my) / (1.0 - this.ry));
    }

    private double bifocal(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = d7 = d < d2 ? d2 - d5 : d6 - d2;
        if (d7 == 0.0) {
            d7 = d6 - d5;
        }
        double d9 = d - d2;
        double d10 = d7 * d3;
        if (Math.abs(d9) <= d10) {
            d = d9 * d4 + d2;
            return d;
        }
        double d11 = d3 * d4;
        d = (Math.abs(d9) - d10) / d7 * ((1.0 - d11) / (1.0 - d3));
        return (double)(d9 < 0.0 ? -1 : 1) * d7 * (d + d11) + d2;
    }

    public double getXMagnification() {
        return this.mx;
    }

    public void setXMagnification(double d) {
        this.mx = d;
    }

    public double getYMagnification() {
        return this.my;
    }

    public void setYMagnification(double d) {
        this.my = d;
    }

    public double getXRange() {
        return this.rx;
    }

    public void setXRange(double d) {
        this.rx = d;
    }

    public double getYRange() {
        return this.ry;
    }

    public void setYRange(double d) {
        this.ry = d;
    }
}

