/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.force;

import edu.berkeley.guir.prefusex.force.ForceItem;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import edu.berkeley.guir.prefusex.force.Integrator;
import java.util.Iterator;

public class EulerIntegrator
implements Integrator {
    public void integrate(ForceSimulator forceSimulator, long l) {
        float f = forceSimulator.getSpeedLimit();
        Iterator iterator = forceSimulator.getItems();
        while (iterator.hasNext()) {
            ForceItem forceItem = (ForceItem)iterator.next();
            forceItem.location[0] = forceItem.location[0] + (float)l * forceItem.velocity[0];
            forceItem.location[1] = forceItem.location[1] + (float)l * forceItem.velocity[1];
            float f2 = (float)l / forceItem.mass;
            forceItem.velocity[0] = forceItem.velocity[0] + f2 * forceItem.force[0];
            forceItem.velocity[1] = forceItem.velocity[1] + f2 * forceItem.force[1];
            float f3 = forceItem.velocity[0];
            float f4 = forceItem.velocity[1];
            float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
            if (!(f5 > f)) continue;
            forceItem.velocity[0] = f * f3 / f5;
            forceItem.velocity[1] = f * f4 / f5;
        }
    }
}

