/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.force;

import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForceItem;
import edu.berkeley.guir.prefusex.force.Integrator;
import edu.berkeley.guir.prefusex.force.RungeKuttaIntegrator;
import edu.berkeley.guir.prefusex.force.Spring;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ForceSimulator {
    private Set items;
    private Set springs;
    private Force[] iforces;
    private Force[] sforces;
    private int iflen;
    private int sflen;
    private Integrator integrator;
    private float speedLimit = 1.0f;

    public ForceSimulator() {
        this(new RungeKuttaIntegrator());
    }

    public ForceSimulator(Integrator integrator) {
        this.integrator = integrator;
        this.iforces = new Force[5];
        this.sforces = new Force[5];
        this.iflen = 0;
        this.sflen = 0;
        this.items = new HashSet();
        this.springs = new HashSet();
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float f) {
        this.speedLimit = f;
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(Integrator integrator) {
        this.integrator = integrator;
    }

    public void clear() {
        this.items.clear();
        Iterator iterator = this.springs.iterator();
        Spring.SpringFactory springFactory = Spring.getFactory();
        while (iterator.hasNext()) {
            springFactory.reclaim((Spring)iterator.next());
        }
        this.springs.clear();
    }

    public void addForce(Force force) {
        Force[] forceArray;
        if (force.isItemForce()) {
            if (this.iforces.length == this.iflen) {
                forceArray = new Force[this.iflen + 10];
                System.arraycopy(this.iforces, 0, forceArray, 0, this.iforces.length);
                this.iforces = forceArray;
            }
            this.iforces[this.iflen++] = force;
        }
        if (force.isSpringForce()) {
            if (this.sforces.length == this.sflen) {
                forceArray = new Force[this.sflen + 10];
                System.arraycopy(this.sforces, 0, forceArray, 0, this.sforces.length);
                this.sforces = forceArray;
            }
            this.sforces[this.sflen++] = force;
        }
    }

    public Force[] getForces() {
        Force[] forceArray = new Force[this.iflen + this.sflen];
        System.arraycopy(this.iforces, 0, forceArray, 0, this.iflen);
        System.arraycopy(this.sforces, 0, forceArray, this.iflen, this.sflen);
        return forceArray;
    }

    public void addItem(ForceItem forceItem) {
        this.items.add(forceItem);
    }

    public boolean removeItem(ForceItem forceItem) {
        return this.items.remove(forceItem);
    }

    public Iterator getItems() {
        return this.items.iterator();
    }

    public Spring addSpring(ForceItem forceItem, ForceItem forceItem2) {
        return this.addSpring(forceItem, forceItem2, -1.0f, -1.0f);
    }

    public Spring addSpring(ForceItem forceItem, ForceItem forceItem2, float f) {
        return this.addSpring(forceItem, forceItem2, -1.0f, f);
    }

    public Spring addSpring(ForceItem forceItem, ForceItem forceItem2, float f, float f2) {
        if (forceItem == null || forceItem2 == null) {
            throw new IllegalArgumentException("ForceItems must be non-null");
        }
        Spring spring = Spring.getFactory().getSpring(forceItem, forceItem2, f, f2);
        this.springs.add(spring);
        return spring;
    }

    public boolean removeSpring(Spring spring) {
        return this.springs.remove(spring);
    }

    public Iterator getSprings() {
        return this.springs.iterator();
    }

    public void runSimulator(long l) {
        this.accumulate();
        this.integrator.integrate(this, l);
    }

    public void accumulate() {
        Object object;
        int n;
        for (n = 0; n < this.iflen; ++n) {
            this.iforces[n].init(this);
        }
        for (n = 0; n < this.sflen; ++n) {
            this.sforces[n].init(this);
        }
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            object = (ForceItem)iterator.next();
            ((ForceItem)object).force[0] = 0.0f;
            ((ForceItem)object).force[1] = 0.0f;
            for (int i = 0; i < this.iflen; ++i) {
                this.iforces[i].getForce((ForceItem)object);
            }
        }
        object = this.springs.iterator();
        while (object.hasNext()) {
            Spring spring = (Spring)object.next();
            for (int i = 0; i < this.sflen; ++i) {
                this.sforces[i].getForce(spring);
            }
        }
    }
}

