/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.force;

import edu.berkeley.guir.prefusex.force.AbstractForce;
import edu.berkeley.guir.prefusex.force.ForceItem;

public class GravitationalForce
extends AbstractForce {
    private static final String[] pnames = new String[]{"GravitationalConstant", "Direction"};
    public static final int GRAVITATIONAL_CONST = 0;
    public static final int DIRECTION = 1;
    public static final float DEFAULT_FORCE_CONSTANT = 1.0E-4f;
    public static final float DEFAULT_DIRECTION = -90.0f;

    public GravitationalForce(float f, float f2) {
        this.params = new float[]{f, f2};
    }

    public GravitationalForce() {
        this(1.0E-4f, -90.0f);
    }

    public boolean isItemForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(ForceItem forceItem) {
        float f = (float)Math.toRadians(-this.params[1]);
        float f2 = this.params[0] * forceItem.mass;
        forceItem.force[0] = (float)((double)forceItem.force[0] + Math.cos(f) * (double)f2);
        forceItem.force[1] = (float)((double)forceItem.force[1] + Math.sin(f) * (double)f2);
    }
}

